% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_fill_pretty_d.R
\name{scale_fill_pretty_d}
\alias{scale_fill_pretty_d}
\title{Plotting with PrettyCols palettes for colour ggplot2}
\usage{
scale_fill_pretty_d(name, direction = 1, ...)
}
\arguments{
\item{name}{Name of Palette. Run \code{names(PrettyColsPalettes)} to view options.}

\item{direction}{Sets order of colors. Default palette is 1. If direction is -1,
palette color order is reversed}

\item{...}{Other arguments passed on to \code{\link[ggplot2]{discrete_scale}}}
}
\value{
A ggproto object defining a discrete fill scale for use with ggplot2.
}
\description{
Plotting with PrettyCols palettes for colour ggplot2
}
\examples{
library(ggplot2)
ggplot(data=iris, aes(x=Species, y=Petal.Length, fill=Species)) +
  geom_col() +
  scale_fill_pretty_d("Relax")
}
