% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_adapters.R
\name{csv_adapter}
\alias{csv_adapter}
\title{Load Price Data from CSV File}
\usage{
csv_adapter(
  file_path,
  date_col = "Date",
  symbol_col = "Symbol",
  price_col = "Price",
  frequency = "daily",
  symbol_order = NULL
)
}
\arguments{
\item{file_path}{Path to CSV file}

\item{date_col}{Name of date column (default: "date")}

\item{symbol_col}{Name of symbol column (default: "symbol")}

\item{price_col}{Name of price column (default: "close")}

\item{frequency}{Target frequency: "daily" or "weekly" (default: "daily")}

\item{symbol_order}{Optional vector to order symbols}
}
\value{
Data.table with Date column and price columns
}
\description{
Reads stock price data from CSV files with flexible column naming.
Automatically standardizes to library format.
}
\examples{
# Create a temporary tidy CSV from included weekly sample data (offline, fast)
data("sample_prices_weekly")
PW <- as.data.frame(sample_prices_weekly)
syms <- setdiff(names(PW), "Date")[1:2]

stk  <- stack(PW[1:10, syms])
tidy <- data.frame(
  Date   = rep(PW$Date[1:10], times = length(syms)),
  Symbol = stk$ind,
  Price  = stk$values
)

tmp <- tempfile(fileext = ".csv")
write.csv(tidy, tmp, row.names = FALSE)
prices <- csv_adapter(tmp)
head(prices)
unlink(tmp)
}
