/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.session;

import org.openfast.Context;
import org.openfast.Message;
import org.openfast.MessageHandler;
import org.openfast.ScalarValue;
import org.openfast.codec.Coder;
import org.openfast.error.ErrorCode;
import org.openfast.session.AbstractSessionControlProtocol;
import org.openfast.session.BasicClient;
import org.openfast.session.Connection;
import org.openfast.session.MessageListener;
import org.openfast.session.Session;
import org.openfast.session.SessionConstants;
import org.openfast.session.SessionListener;
import org.openfast.template.Field;
import org.openfast.template.MessageTemplate;
import org.openfast.template.Scalar;
import org.openfast.template.TemplateRegistry;
import org.openfast.template.operator.Operator;
import org.openfast.template.type.Type;

class SessionControlProtocol_1_0
extends AbstractSessionControlProtocol {
    static final int FAST_HELLO_TEMPLATE_ID = 16000;
    static final int FAST_ALERT_TEMPLATE_ID = 16001;
    public static final MessageTemplate FAST_ALERT_TEMPLATE = new MessageTemplate("", new Field[]{new Scalar("Severity", Type.U32, Operator.NONE, ScalarValue.UNDEFINED, false), new Scalar("Code", Type.U32, Operator.NONE, ScalarValue.UNDEFINED, false), new Scalar("Value", Type.U32, Operator.NONE, ScalarValue.UNDEFINED, true), new Scalar("Description", Type.ASCII, Operator.NONE, ScalarValue.UNDEFINED, false)});
    public static final MessageTemplate FAST_HELLO_TEMPLATE = new MessageTemplate("", new Field[]{new Scalar("SenderName", Type.ASCII, Operator.NONE, ScalarValue.UNDEFINED, false)});
    private static final MessageHandler RESET_HANDLER = new MessageHandler(){

        public void handleMessage(Message readMessage, Context context, Coder coder) {
            coder.reset();
        }
    };

    SessionControlProtocol_1_0() {
    }

    public Session onNewConnection(String serverName, Connection connection) {
        Session session = new Session(connection, this, TemplateRegistry.NULL, TemplateRegistry.NULL);
        Message message = session.in.readMessage();
        session.out.writeMessage(SessionControlProtocol_1_0.createHelloMessage(serverName));
        String clientName = message.getString(1);
        session.setClient(new BasicClient(clientName, "unknown"));
        return session;
    }

    public Session connect(String senderName, Connection connection, TemplateRegistry inboundRegistry, TemplateRegistry outboundRegistry, MessageListener messageListener, SessionListener sessionListener) {
        Session session = new Session(connection, this, inboundRegistry, outboundRegistry);
        session.setSessionListener(sessionListener);
        session.out.writeMessage(SessionControlProtocol_1_0.createHelloMessage(senderName));
        Message message = session.in.readMessage();
        session.setMessageHandler(messageListener);
        String serverName = message.getString(1);
        session.setClient(new BasicClient(serverName, "unknown"));
        return session;
    }

    public void onError(Session session, ErrorCode code, String message) {
        session.out.writeMessage(SessionControlProtocol_1_0.createFastAlertMessage(code));
    }

    public void registerSessionTemplates(TemplateRegistry registry) {
        registry.register(16000, FAST_HELLO_TEMPLATE);
        registry.register(16001, FAST_ALERT_TEMPLATE);
        registry.register(120, FAST_RESET_TEMPLATE);
    }

    public void configureSession(Session session) {
        this.registerSessionTemplates(session.in.getTemplateRegistry());
        this.registerSessionTemplates(session.out.getTemplateRegistry());
        session.in.addMessageHandler(FAST_RESET_TEMPLATE, RESET_HANDLER);
        session.out.addMessageHandler(FAST_RESET_TEMPLATE, RESET_HANDLER);
    }

    public static Message createFastAlertMessage(ErrorCode code) {
        Message alert = new Message(FAST_ALERT_TEMPLATE);
        alert.setInteger(1, code.getSeverity().getCode());
        alert.setInteger(2, code.getCode());
        alert.setString(4, code.getDescription());
        return alert;
    }

    public static Message createHelloMessage(String name) {
        Message message = new Message(FAST_HELLO_TEMPLATE);
        message.setString(1, name);
        return message;
    }

    public void handleMessage(Session session, Message message) {
        if (message.getTemplate().equals((Object)FAST_ALERT_TEMPLATE)) {
            ErrorCode alertCode = ErrorCode.getAlertCode(message);
            if (alertCode.equals(SessionConstants.CLOSE)) {
                session.close(alertCode);
            } else {
                session.getErrorHandler().error(alertCode, message.getString(4));
            }
        }
    }

    public boolean isProtocolMessage(Message message) {
        if (message == null) {
            return false;
        }
        return message.getTemplate().equals((Object)FAST_ALERT_TEMPLATE) || message.getTemplate().equals((Object)FAST_HELLO_TEMPLATE) || message.getTemplate().equals((Object)FAST_RESET_TEMPLATE);
    }

    public boolean supportsTemplateExchange() {
        return false;
    }

    public Message createTemplateDeclarationMessage(MessageTemplate messageTemplate, int templateId) {
        throw new UnsupportedOperationException();
    }

    public Message createTemplateDefinitionMessage(MessageTemplate messageTemplate) {
        throw new UnsupportedOperationException();
    }

    public Message getCloseMessage() {
        return SessionControlProtocol_1_0.createFastAlertMessage(SessionConstants.CLOSE);
    }

    public MessageTemplate createTemplateFromMessage(Message templateDef, TemplateRegistry registry) {
        throw new UnsupportedOperationException();
    }
}

