/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template;

import org.openfast.NumericValue;

public class LongValue
extends NumericValue {
    private static final long serialVersionUID = 1L;
    public final long value;

    public LongValue(long value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof NumericValue)) {
            return false;
        }
        return this.equals((NumericValue)obj);
    }

    private boolean equals(NumericValue otherValue) {
        return this.value == otherValue.toLong();
    }

    public int hashCode() {
        return (int)this.value;
    }

    public boolean equalsValue(String defaultValue) {
        return (long)Integer.parseInt(defaultValue) == this.value;
    }

    public NumericValue increment() {
        return new LongValue(this.value + 1L);
    }

    public NumericValue decrement() {
        return new LongValue(this.value - 1L);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public Object toObject() {
        return this.value;
    }

    public NumericValue subtract(NumericValue subend) {
        return new LongValue(this.value - subend.toLong());
    }

    public NumericValue add(NumericValue addend) {
        return new LongValue(this.value + addend.toLong());
    }

    public String serialize() {
        return String.valueOf(this.value);
    }

    public boolean equals(int value) {
        return (long)value == this.value;
    }

    public long toLong() {
        return this.value;
    }

    public int toInt() {
        return (int)this.value;
    }
}

