/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.portfolio;

import com.portfolioeffect.quant.client.ClientConnection;
import com.portfolioeffect.quant.client.portfolio.Portfolio;
import com.portfolioeffect.quant.client.portfolio.Task;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ParallelBatchs {
    private static final int THREAD_NUMBER = 50;
    private List<Portfolio> portfolioList = new ArrayList<Portfolio>();

    public void addPortfolio(Portfolio portfolio) {
        this.portfolioList.add(portfolio);
    }

    public void finishBatch() {
        ParallelBatchs.finishBatch(this.portfolioList);
        this.portfolioList.clear();
    }

    public static void finishBatch(List<Portfolio> portfolioList) {
        Portfolio[] portfolioArray = portfolioList.toArray(new Portfolio[portfolioList.size()]);
        ParallelBatchs.finishBatch(portfolioArray);
    }

    public static void finishBatch(Portfolio[] portfolioArray) {
        double nDone;
        ArrayList<Task> taskList = new ArrayList<Task>();
        Portfolio[] portfolioArray2 = portfolioArray;
        int n = portfolioArray.length;
        int n2 = 0;
        while (n2 < n) {
            Portfolio e = portfolioArray2[n2];
            taskList.add(new Task(e));
            ++n2;
        }
        ExecutorService executorService = Executors.newFixedThreadPool(50);
        ArrayList<Future<Boolean>> futureList = new ArrayList<Future<Boolean>>();
        for (Task e : taskList) {
            futureList.add(executorService.submit(e));
        }
        ClientConnection clientProgressBar = new ClientConnection();
        clientProgressBar.printProgressBar(0.0);
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            nDone = 0.0;
            for (Future future : futureList) {
                if (!future.isDone()) continue;
                nDone += 1.0;
            }
            clientProgressBar.printProgressBar(nDone / (double)futureList.size());
        } while (nDone != (double)futureList.size());
        executorService.shutdown();
    }
}

