% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/LinMatrixL.R
\name{LinMatrixL}
\alias{LinMatrixL}
\title{The linearized matrix L}
\usage{
LinMatrixL(model_switch, xt_ind, x, a, bpop, b_ind, bocc_ind, poped.db)
}
\arguments{
\item{model_switch}{A vector that is the same size as xt, specifying which model each sample belongs to.}

\item{xt_ind}{A vector of sample times.}

\item{x}{A vector for the discrete design variables.}

\item{a}{A vector of covariates.}

\item{bpop}{The fixed effects parameter values.  Supplied as a vector.}

\item{b_ind}{The point at which to evaluate the derivative}

\item{bocc_ind}{The point at which to evaluate the derivative}

\item{poped.db}{A PopED database.}
}
\value{
As a list:
\item{y}{A matrix of size (samples per individual x number of random effects)}
\item{poped.db}{A PopED database}
}
\description{
Function computes the derivative of the model with respect to the between subject variability
terms in the model (b's and bocc's) evaluated at
a defined point
(b_ind and bocc_ind).
}
\examples{
## Warfarin example from software comparison in:
## Nyberg et al., "Methods and software tools for design evaluation 
##   for population pharmacokinetics-pharmacodynamics studies", 
##   Br. J. Clin. Pharm., 2014. 

## Optimization using an additive + proportional reidual error to 
##   avoid sample times at very low concentrations (time 0 or very late samoples).
library(PopED)

## find the parameters that are needed to define from the structural model
ff.PK.1.comp.oral.sd.CL

## -- parameter definition function 
## -- names match parameters in function ff
sfg <- function(x,a,bpop,b,bocc){
  parameters=c(CL=bpop[1]*exp(b[1]),
               V=bpop[2]*exp(b[2]),
               KA=bpop[3]*exp(b[3]),
               Favail=bpop[4],
               DOSE=a[1])
  return(parameters) 
}

## -- Define initial design  and design space
poped.db <- create.poped.database(ff_file="ff.PK.1.comp.oral.sd.CL",
                                  fg_file="sfg",
                                  fError_file="feps.add.prop",
                                  bpop=c(CL=0.15, V=8, KA=1.0, Favail=1), 
                                  notfixed_bpop=c(1,1,1,0),
                                  d=c(CL=0.07, V=0.02, KA=0.6), 
                                  sigma=c(0.01,0.25),
                                  groupsize=32,
                                  xt=c( 0.5,1,2,6,24,36,72,120),
                                  minxt=0,
                                  maxxt=120,
                                  a=70,
                                  mina=0,
                                  maxa=100)
# warfarin optimization model

#for the FO approximation
ind=1
LinMatrixL(model_switch=t(poped.db$design$model_switch[ind,,drop=FALSE]),
          xt_ind=t(poped.db$design$xt[ind,,drop=FALSE]),
          x=zeros(0,1),
          a=t(poped.db$design$a[ind,,drop=FALSE]),
          bpop=poped.db$parameters$bpop[,2,drop=FALSE],
          b_ind=zeros(poped.db$parameters$NumRanEff,1),
          bocc_ind=zeros(poped.db$parameters$NumDocc,1),
          poped.db)["y"]

}

