% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolyHaplotyper.R
\name{pedigreeHapCheck}
\alias{pedigreeHapCheck}
\title{check the consistency of haploblock genotypes over a pedigree}
\usage{
pedigreeHapCheck(ped, mrkDosage, haploblock, hapresults)
}
\arguments{
\item{ped}{data.frame or matrix listing the pedigree. Column 1 has names of
all individuals (no duplicates, no NA), column 2 and 3 have the parents
(duplicates and NA allowed, also individuals with one known parent or
with two identical parents allowed). No sorting of the pedigree is needed.
All parents should also be listed as individuals; if that is not the case
the missing parents will be added as founders and a warning will be issued.}

\item{mrkDosage}{a matrix with one row for each marker
and one column for each individual, with the observed dosages. Individuals
with one or more NA dosages are considered to have no marker data. Individual
names are the colnames, no duplicates allowed; the set of individuals
needs not be the same as those in ped; individual names common to mrkDosage
and ped must be exactly identical (upper/lower case and whitespace included)}

\item{haploblock}{a list of character vectors. The names are the names of the
haploblocks, the character vectors have the names of the markers in each
haploblock}

\item{hapresults}{a list as returned by inferHaplotypes, with one
item per haploblock, containing at least all those in the list
specified by haploblock}
}
\value{
a list with two items:\cr
- ped_arr: a 3D logical array with dimensions individuals, diagnostics and
haploblocks. For each individual and each haploblock there are 4
diagnostics:\cr
 * mrk: does the individual have complete marker dosage data?\cr
 * imp: were the marker dosages for this individual imputed?\cr
 * hap: is there a haplotype combination assigned to the individual?\cr
 * noDR: does the haplotype genotype of the individual match that of its
 parents, assuming polysomic inheritance but no Double Reduction? NA if the
 individual or both its parents do not have a haplotype genotype assigned\cr
 * withDR: as noDR, but allowing Double Reduction\cr
- parents_arr: a 3D integer array with dimensions parents (all individuals
that occur as parents in the pedigree), diagnostics and haploblocks.
For each parent and each haploblock there are 7 diagnostics:\cr
* par_mrkdata: 0=FALSE, 1=TRUE, does this parent have complete marker data?\cr
* par_hapdata: 0=FALSE, 1=TRUE, does this parent have a haplotype
genotype assigned?\cr
* totprogeny: how many first-generation progeny (children) does this parent
have (combined over all its matings, both as mother and as father)\cr
* prog_mrkdata: how many progeny have complete marker dosage data?\cr
* prog_hapdata: how many progeny have a haplotype combination assigned?\cr
* nonDRmatch: how many progeny have a haplotype combination that is
compatible with their parent's haplotype combinations, assuming polysomic
inheritance but no Double Reduction\cr
* DRmatch: as nonDRmatch, but also allowing DR\cr
Both ped_arr and parents_arr contain all haploblocks in haploblock, also
those skipped because of too many markers and those without any haplotyped
individuals. These can be excluded by excluding them from the haploblock list.
}
\description{
For all haploblocks, check whether the inheritance of inferred
haplotypes over the pedigree is consistent without or with allowing for
double reduction (DR), and assuming polysomic inheritance.
}
\examples{
data(PolyHaplotyper_small)
phchk <- pedigreeHapCheck(ped=phped, mrkDosage=phdos, haploblock=phblocks,
                         hapresults=phresults)
# show the top of the ped_arr for haploblock 1:
phchk$ped_arr[1:6,,1]
# show the top of the parents_arr for haploblock 1:
phchk$parents_arr[1:6,,1]
}
