% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolyHaplotyper.R
\name{calcMrkHaptable}
\alias{calcMrkHaptable}
\title{produce a table of nr of markers vs nr of haplotypes}
\usage{
calcMrkHaptable(ovwFS)
}
\arguments{
\item{ovwFS}{a list as produced by overviewFS. Only the first 2 columns of
list item ovw are used}
}
\value{
a frequency table with the numbers of haploblocks, with
all combinations of marker counts and inferred haplotype counts per haploblock.
The column with haplotype count NA (if any) shows the haploblocks for which
no haplotype solution was found (the reason for that would usually be found
in column 1 of ovwFS$messages)
}
\description{
produce a table of nr of markers vs nr of haplotypes
}
\examples{
data(PolyHaplotyper_small)
phovw <- overviewByFS(haploblock=phblocks, parents=phpar, FS=phFS,
                     hapresults=phresults)
# in this small dataset there are only 2 haploblocks, each with 4 markers:
calcMrkHaptable(ovwFS=phovw)
# in both haploblocks 5 haplotypes are inferred
}
