% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoloniexPublic.R
\docType{methods}
\name{Return24hVolume,PoloniexPublicAPI-method}
\alias{Return24hVolume,PoloniexPublicAPI-method}
\title{Returns 24-hour trading volumes for all available markets.
Additionally, total trading volumes for the 5 primary currencies
are also retrieved.}
\usage{
\S4method{Return24hVolume}{PoloniexPublicAPI}(theObject)
}
\arguments{
\item{theObject}{The public client API object on which the function should be called}
}
\value{
A list containing the 24 hour volume information.
 volume.pairs: A dataframe
  Rows    - Cryptocurrency Trading Pairs.
            Every pair represents a market.
  Columns - Transacted trading volumes for a particular market.
            Volumes are expressed in both base currency units and quoted
            currency units.
 volume.totals: Total trading volumes of five primary currencies.
}
\description{
Returns 24-hour trading volumes for all available markets.
Additionally, total trading volumes for the 5 primary currencies
are also retrieved.
}
\examples{
poloniex.public <- PoloniexPublicAPI()
volume.info <- Return24hVolume(poloniex.public)
head(volume.info$volume.pairs)
volume.info$volume.totals
}
