% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSDM.R
\name{dataSDM}
\alias{dataSDM}
\title{R6 class for creating a \code{dataSDM} object.}
\description{
A data object containing the data and the relevant information about the integrated model. The function \code{\link{intModel}} acts as a wrapper in creating one of these objects. The output of this object has additional functions within the object which allow for further specification and customization of the integrated model.
}
\note{
The arguments of this function may be missing (ie not provided) if they have already been specified in \code{\link{intModel}}, and do not need changing. Therefore this function is useful if there are some variable names not standardized across the datasets; this function will thus standardize the variable names to those provided initially in \code{\link{intModel}}.
}
\examples{

## ------------------------------------------------
## Method `dataSDM$plot`
## ------------------------------------------------


 if (requireNamespace('INLA')) {
   
 #Get Data
 data("SolitaryTinamou")
 proj <- CRS("+proj=longlat +ellps=WGS84")
 data <- SolitaryTinamou$datasets
 mesh <- SolitaryTinamou$mesh
 mesh$crs <- proj
 
 #Set model up
 organizedData <- intModel(data, Mesh = mesh, Coordinates = c('X', 'Y'),
                             Projection = proj, responsePA = 'Present')
 
  #Create plot of data
  organizedData$plot()

}

## ------------------------------------------------
## Method `dataSDM$addData`
## ------------------------------------------------

 
 if (requireNamespace('INLA')) {
   
 #Get Data
 data("SolitaryTinamou")
 proj <- CRS("+proj=longlat +ellps=WGS84")
 
 #Only select eBird data
 ebird <- SolitaryTinamou$datasets$eBird
 mesh <- SolitaryTinamou$mesh
 mesh$crs <- proj
 
 #Set model up
 organizedData <- intModel(ebird, Mesh = mesh, Coordinates = c('X', 'Y'),
                             Projection = proj)
                             
 #Print summary
 organizedData
 
 #Add new dataset
 Parks = SolitaryTinamou$datasets$Parks
 organizedData$addData(Parks, responsePA = 'Present')
 
 #Print summary
 organizedData
   
 }

## ------------------------------------------------
## Method `dataSDM$addBias`
## ------------------------------------------------

 if (requireNamespace('INLA')) {
   
 #Get Data
 data("SolitaryTinamou")
 proj <- CRS("+proj=longlat +ellps=WGS84")
 data <- SolitaryTinamou$datasets
 mesh <- SolitaryTinamou$mesh
 mesh$crs <- proj
 
 #Set model up
 organizedData <- intModel(data, Mesh = mesh, Coordinates = c('X', 'Y'),
                             Projection = proj, responsePA = 'Present')
 
#Add bias field to eBird records
organizedData$addBias(datasetNames = 'eBird')

}

## ------------------------------------------------
## Method `dataSDM$updateFormula`
## ------------------------------------------------


 if (requireNamespace('INLA')) {
   
 #Get Data
 data("SolitaryTinamou")
 proj <- CRS("+proj=longlat +ellps=WGS84")
 data <- SolitaryTinamou$datasets
 mesh <- SolitaryTinamou$mesh
 mesh$crs <- proj
 Forest <- SolitaryTinamou$covariates$Forest
 
 
 #Set model up
 organizedData <- intModel(data, Mesh = mesh, Coordinates = c('X', 'Y'),
                           spatialCovariates = Forest,
                           Projection = proj, responsePA = 'Present',
                           pointsSpatial = 'individual')

 #Remove Forest from eBird
 organizedData$updateFormula(datasetName = 'eBird', Formula = ~ . - Forest)

}


## ------------------------------------------------
## Method `dataSDM$changeComponents`
## ------------------------------------------------

\dontrun{

 if (requireNamespace('INLA')) {
   
 #Get Data
 data("SolitaryTinamou")
 proj <- CRS("+proj=longlat +ellps=WGS84")
 data <- SolitaryTinamou$datasets
 mesh <- SolitaryTinamou$mesh
 mesh$crs <- proj
 Forest <- SolitaryTinamou$covariates$Forest
 
 
 #Set model up
 organizedData <- intModel(data, Mesh = mesh, Coordinates = c('X', 'Y'),
                           spatialCovariates = Forest,
                           Projection = proj, responsePA = 'Present')

 #Remove Forest from components
 organizedData$changeComponents(removeComponent = 'Forest')

}

}

## ------------------------------------------------
## Method `dataSDM$priorsFixed`
## ------------------------------------------------

 if (requireNamespace('INLA')) {
   
 #Get Data
 data("SolitaryTinamou")
 proj <- CRS("+proj=longlat +ellps=WGS84")
 data <- SolitaryTinamou$datasets
 mesh <- SolitaryTinamou$mesh
 mesh$crs <- proj
 Forest <- SolitaryTinamou$covariates$Forest
 
 
 #Set model up
 organizedData <- intModel(data, Mesh = mesh, Coordinates = c('X', 'Y'),
                           spatialCovariates = Forest,
                           Projection = proj, responsePA = 'Present',
                           pointsSpatial = 'individual')

 #Add prior to Forest
 organizedData$priorsFixed(Effect = 'Forest', mean.linear = 2, prec.linear = 0.1)

}

## ------------------------------------------------
## Method `dataSDM$specifySpatial`
## ------------------------------------------------

 if (requireNamespace('INLA')) {
   
 #Get Data
 data("SolitaryTinamou")
 proj <- CRS("+proj=longlat +ellps=WGS84")
 data <- SolitaryTinamou$datasets
 mesh <- SolitaryTinamou$mesh
 mesh$crs <- proj
 Forest <- SolitaryTinamou$covariates$Forest
 
 
 #Set model up
 organizedData <- intModel(data, Mesh = mesh, Coordinates = c('X', 'Y'),
                           spatialCovariates = Forest,
                           Projection = proj, responsePA = 'Present')

 #Specify the shared spatial field
 organizedData$specifySpatial(sharedSpatial = TRUE, PC = TRUE, 
                       prior.range = c(1,0.001),
                       prior.sigma = c(1,0.001))

} 

## ------------------------------------------------
## Method `dataSDM$changeLink`
## ------------------------------------------------

\dontrun{

#Create data object
dataObj <- intModel(...)

#Print link function for a process

dataObj$changeLink(Dataset = Dataset, Species = Species)

#Change link function
dataObj$changeLink(Dataset = Dataset, Species = Species,
                   Link = "log")

}

## ------------------------------------------------
## Method `dataSDM$spatialBlock`
## ------------------------------------------------

 if (requireNamespace('INLA')) {
   
 #Get Data
 data("SolitaryTinamou")
 proj <- CRS("+proj=longlat +ellps=WGS84")
 data <- SolitaryTinamou$datasets
 mesh <- SolitaryTinamou$mesh
 mesh$crs <- proj
 Forest <- SolitaryTinamou$covariates$Forest
 
 
 #Set model up
 organizedData <- intModel(data, Mesh = mesh, Coordinates = c('X', 'Y'),
                           spatialCovariates = Forest,
                           Projection = proj, responsePA = 'Present',
                           pointsSpatial = 'individual')

 #Specify the spatial block
 organizedData$spatialBlock(k = 2, rows = 2, cols = 1, plot = TRUE)

} 

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-dataSDM-print}{\code{dataSDM$print()}}
\item \href{#method-dataSDM-plot}{\code{dataSDM$plot()}}
\item \href{#method-dataSDM-addData}{\code{dataSDM$addData()}}
\item \href{#method-dataSDM-addBias}{\code{dataSDM$addBias()}}
\item \href{#method-dataSDM-updateFormula}{\code{dataSDM$updateFormula()}}
\item \href{#method-dataSDM-changeComponents}{\code{dataSDM$changeComponents()}}
\item \href{#method-dataSDM-priorsFixed}{\code{dataSDM$priorsFixed()}}
\item \href{#method-dataSDM-specifySpatial}{\code{dataSDM$specifySpatial()}}
\item \href{#method-dataSDM-changeLink}{\code{dataSDM$changeLink()}}
\item \href{#method-dataSDM-spatialBlock}{\code{dataSDM$spatialBlock()}}
\item \href{#method-dataSDM-new}{\code{dataSDM$new()}}
\item \href{#method-dataSDM-samplingBias}{\code{dataSDM$samplingBias()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dataSDM-print"></a>}}
\if{latex}{\out{\hypertarget{method-dataSDM-print}{}}}
\subsection{Method \code{print()}}{
Prints the datasets, their data type and the number of observations, as well as the marks and their respective families.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dataSDM$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Not used.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dataSDM-plot"></a>}}
\if{latex}{\out{\hypertarget{method-dataSDM-plot}{}}}
\subsection{Method \code{plot()}}{
Makes a plot of the points surrounded by the boundary of the region where they were collected. The points may either be plotted based on which dataset they come from, or which species group they are part of (if \code{speciesName} is non-\code{NULL} in \code{\link{intModel}}).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dataSDM$plot(datasetNames, Species = FALSE, Boundary = TRUE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{datasetNames}}{Name of the datasets to plot. If this argument is missing, the function will plot all the data available to the model.}

\item{\code{Species}}{Logical: should the points be plotted based on the species name. Defaults to \code{FALSE}.}

\item{\code{Boundary}}{Logical: should a boundary (created using the \code{Mesh} object) be used in the plot. Defaults to \code{TRUE}. Note that the output of this function is a \code{gg} object, and so a boundary surrounding the points may be added using standard \pkg{ggplot2} syntax and the \code{\link[inlabru]{gg}} function provided in the \pkg{inlabru} package.}

\item{\code{...}}{Not used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A ggplot object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{
 if (requireNamespace('INLA')) {
   
 #Get Data
 data("SolitaryTinamou")
 proj <- CRS("+proj=longlat +ellps=WGS84")
 data <- SolitaryTinamou$datasets
 mesh <- SolitaryTinamou$mesh
 mesh$crs <- proj
 
 #Set model up
 organizedData <- intModel(data, Mesh = mesh, Coordinates = c('X', 'Y'),
                             Projection = proj, responsePA = 'Present')
 
  #Create plot of data
  organizedData$plot()

}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dataSDM-addData"></a>}}
\if{latex}{\out{\hypertarget{method-dataSDM-addData}{}}}
\subsection{Method \code{addData()}}{
Function used to add additional datasets to the \code{dataSDM} object. This function should be used if the user would like to add any additional datasets to the integrated model, but do not have the same standardized variable names as those added initially with \code{\link{intModel}}. Use \code{?intModel} for a more comprehensive description on what each argument in this function is used for.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dataSDM$addData(
  ...,
  responseCounts,
  responsePA,
  trialsPA,
  markNames,
  markFamily,
  pointCovariates,
  trialsMarks,
  speciesName,
  temporalName,
  Coordinates,
  Offset
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{The datasets to be added to the integrated model: should be either \code{data.frame} or \code{SpatialPoints*} objects, or a list of objects from these classes.}

\item{\code{responseCounts}}{The name of the response variable for the counts data.}

\item{\code{responsePA}}{The name of the response variable for the presence absence data.}

\item{\code{trialsPA}}{The name of the trials variable for the presence absence data.}

\item{\code{markNames}}{The names of the marks found in the data.}

\item{\code{markFamily}}{The associated distributions of the marks.}

\item{\code{pointCovariates}}{The additional, non-spatial covariates describing the data.}

\item{\code{trialsMarks}}{The name of the trials variable for the binomial marks.}

\item{\code{speciesName}}{The name of the species variable included in the data. Used to make a stacked species distribution model.}

\item{\code{temporalName}}{The name of the temporal variable in the datasets.}

\item{\code{Coordinates}}{A vector of length 2 describing the names of the coordinates of the data.}

\item{\code{Offset}}{Name of the offset column in the dataset}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ 
 if (requireNamespace('INLA')) {
   
 #Get Data
 data("SolitaryTinamou")
 proj <- CRS("+proj=longlat +ellps=WGS84")
 
 #Only select eBird data
 ebird <- SolitaryTinamou$datasets$eBird
 mesh <- SolitaryTinamou$mesh
 mesh$crs <- proj
 
 #Set model up
 organizedData <- intModel(ebird, Mesh = mesh, Coordinates = c('X', 'Y'),
                             Projection = proj)
                             
 #Print summary
 organizedData
 
 #Add new dataset
 Parks = SolitaryTinamou$datasets$Parks
 organizedData$addData(Parks, responsePA = 'Present')
 
 #Print summary
 organizedData
   
 }
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dataSDM-addBias"></a>}}
\if{latex}{\out{\hypertarget{method-dataSDM-addBias}{}}}
\subsection{Method \code{addBias()}}{
Function used to add additional spatial fields (called \emph{bias fields}) to a selected dataset present in the integrated model. \emph{Bias fields} are typically used to account for sampling biases in opportunistic citizen science data in the absence of any covariate to do such.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dataSDM$addBias(datasetNames = NULL, allPO = FALSE, biasField = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{datasetNames}}{A vector of dataset names (class \code{character}) for which a bias field needs to be added to. If \code{NULL} (default), then \code{allPO} has to be \code{TRUE}.}

\item{\code{allPO}}{Logical: should a bias field be added to all datasets classified as presence only in the integrated model. Defaults to \code{FALSE}.}

\item{\code{biasField}}{An \code{inla.spde} object used to describe the bias field. Defaults to \code{NULL} which uses \code{\link[INLA]{inla.spde2.matern}} to create a Matern model for the field.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ if (requireNamespace('INLA')) {
   
 #Get Data
 data("SolitaryTinamou")
 proj <- CRS("+proj=longlat +ellps=WGS84")
 data <- SolitaryTinamou$datasets
 mesh <- SolitaryTinamou$mesh
 mesh$crs <- proj
 
 #Set model up
 organizedData <- intModel(data, Mesh = mesh, Coordinates = c('X', 'Y'),
                             Projection = proj, responsePA = 'Present')
 
#Add bias field to eBird records
organizedData$addBias(datasetNames = 'eBird')

}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dataSDM-updateFormula"></a>}}
\if{latex}{\out{\hypertarget{method-dataSDM-updateFormula}{}}}
\subsection{Method \code{updateFormula()}}{
Function used to update the formula for a selected observation model. The function is designed to work similarly to the generic \code{update} formula, and should be used to thin terms out of a process from the full model specified in \code{\link{intModel}}. The function also allows the user to add their own formula to the model, such that they can include non-linear components in the model. The function can also be used to print out the formula for a process by not specifying the \code{Formula} or \code{newFormula} arguments.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dataSDM$updateFormula(
  datasetName = NULL,
  Points = TRUE,
  speciesName = NULL,
  markName = NULL,
  Formula,
  allProcesses = FALSE,
  newFormula
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{datasetName}}{Name of the dataset (class \code{character}) for which the formula needs to be changed.}

\item{\code{Points}}{Logical: should the formula be changed for the points (or otherwise, a marked process). Defaults to \code{TRUE}. If \code{FALSE}, then \code{markNames} needs to be non-\code{NULL} in \code{\link{intModel}}.}

\item{\code{speciesName}}{Name of the species (class \code{character}) to change the formula for. Defaults to \code{NULL}. If \code{NULL} and \code{speciesName} is non-\code{NULL} in \code{\link{intModel}}, will update the formula for all species within the dataset. Cannot be non-\code{NULL} if \code{speciesName} is \code{NULL} in \code{\link{intModel}}.}

\item{\code{markName}}{Name of the mark (class \code{character}) to change the formula for. Defaults to \code{NULL}. If \code{NULL} and \code{markNames} is non-\code{NULL} in \code{\link{intModel}}, will update the formula for all marks within the dataset. Cannot be non-\code{NULL} if \code{markNames} is \code{NULL} in \code{\link{intModel}}.}

\item{\code{Formula}}{An updated formula to give to the process. The syntax provided for the formula in this argument should be identical to the formula specification as in base \strong{R}. Should be used to thin terms out of a formula but could be used to add terms as well. If adding new terms not specified in \code{intModel}, remember to add the associated component using \code{.$addComponents} as well.}

\item{\code{allProcesses}}{Logical argument: if \code{TRUE} changes the formulas for all of the processes in a dataset. Defaults to \code{FALSE}.}

\item{\code{newFormula}}{Completely change the formula for a process -- primarily used to add non-linear components into the formula. Note: all terms need to be correctly specified here.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If \code{Formula} and \code{newFormula} are missing, will print out the formula for the specified processes.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{
 if (requireNamespace('INLA')) {
   
 #Get Data
 data("SolitaryTinamou")
 proj <- CRS("+proj=longlat +ellps=WGS84")
 data <- SolitaryTinamou$datasets
 mesh <- SolitaryTinamou$mesh
 mesh$crs <- proj
 Forest <- SolitaryTinamou$covariates$Forest
 
 
 #Set model up
 organizedData <- intModel(data, Mesh = mesh, Coordinates = c('X', 'Y'),
                           spatialCovariates = Forest,
                           Projection = proj, responsePA = 'Present',
                           pointsSpatial = 'individual')

 #Remove Forest from eBird
 organizedData$updateFormula(datasetName = 'eBird', Formula = ~ . - Forest)

}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dataSDM-changeComponents"></a>}}
\if{latex}{\out{\hypertarget{method-dataSDM-changeComponents}{}}}
\subsection{Method \code{changeComponents()}}{
Function to add and specify custom components to model, which are required by \pkg{inlabru}. The main purpose of the function is to re-specify or completely change components already in the model, however the user can also add completely new components to the model as well. In this case, the components need to be added to the correct formulas in the model using the \code{.$updateFormula} function. If \code{addComponent} and \code{removeComponent} are both missing, the function will print out the components to be supplied to \pkg{inlabru}'s \code{\link{bru}} function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dataSDM$changeComponents(addComponent, removeComponent, print = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{addComponent}}{Component to add to the integrated model. Note that if the user is re-specifying a component already present in the model, they do not need to remove the old component using \code{removeComponent}.}

\item{\code{removeComponent}}{Component (or just the name of a component) present in the model which should be removed.}

\item{\code{print}}{Logical: should the updated components be printed. Defaults to \code{TRUE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{

 if (requireNamespace('INLA')) {
   
 #Get Data
 data("SolitaryTinamou")
 proj <- CRS("+proj=longlat +ellps=WGS84")
 data <- SolitaryTinamou$datasets
 mesh <- SolitaryTinamou$mesh
 mesh$crs <- proj
 Forest <- SolitaryTinamou$covariates$Forest
 
 
 #Set model up
 organizedData <- intModel(data, Mesh = mesh, Coordinates = c('X', 'Y'),
                           spatialCovariates = Forest,
                           Projection = proj, responsePA = 'Present')

 #Remove Forest from components
 organizedData$changeComponents(removeComponent = 'Forest')

}

}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dataSDM-priorsFixed"></a>}}
\if{latex}{\out{\hypertarget{method-dataSDM-priorsFixed}{}}}
\subsection{Method \code{priorsFixed()}}{
Function to change priors for the fixed (and possibly random) effects of the model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dataSDM$priorsFixed(
  Effect,
  Species = NULL,
  datasetName = NULL,
  mean.linear = 0,
  prec.linear = 0.001
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Effect}}{Name of the fixed effect covariate to change the prior for. Can take on \code{'intercept'}, which will change the specification for an intercept (specified by one of \code{species} or \code{datasetName}).}

\item{\code{Species}}{Name of the species (class \code{character}) for which the prior should change. Defaults to \code{NULL} which will change the prior for all species added to the model.}

\item{\code{datasetName}}{Name of the dataset for which the prior of the intercept should change (if fixedEffect = 'intercept'). Defaults to \code{NULL} which will change the prior effect of the intercepts for all the datasets in the model.}

\item{\code{mean.linear}}{Mean value for the prior of the fixed effect. Defaults to \code{0}.}

\item{\code{prec.linear}}{Precision value for the prior of the fixed effect. Defaults to \code{0.001}.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ if (requireNamespace('INLA')) {
   
 #Get Data
 data("SolitaryTinamou")
 proj <- CRS("+proj=longlat +ellps=WGS84")
 data <- SolitaryTinamou$datasets
 mesh <- SolitaryTinamou$mesh
 mesh$crs <- proj
 Forest <- SolitaryTinamou$covariates$Forest
 
 
 #Set model up
 organizedData <- intModel(data, Mesh = mesh, Coordinates = c('X', 'Y'),
                           spatialCovariates = Forest,
                           Projection = proj, responsePA = 'Present',
                           pointsSpatial = 'individual')

 #Add prior to Forest
 organizedData$priorsFixed(Effect = 'Forest', mean.linear = 2, prec.linear = 0.1)

}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dataSDM-specifySpatial"></a>}}
\if{latex}{\out{\hypertarget{method-dataSDM-specifySpatial}{}}}
\subsection{Method \code{specifySpatial()}}{
Function to specify random fields in the model using penalizing complexity (PC) priors for the parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dataSDM$specifySpatial(
  sharedSpatial = FALSE,
  datasetName,
  Species,
  Mark,
  Bias,
  PC = TRUE,
  Remove = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sharedSpatial}}{Logical: specify the shared spatial field in the model. Requires \code{pointsSpatial == 'shared'} in \code{\link{intModel}}. Defaults to \code{FALSE}.}

\item{\code{datasetName}}{Name of which of the datasets' spatial fields to be specified. Requires \code{pointsSpatial = 'individual'} in \code{\link{intModel}}.}

\item{\code{Species}}{Name of which of the species' spatial field to be specified. Requires \code{speciesName} to be non-\code{NULL} in \code{\link{intModel}}.}

\item{\code{Mark}}{Name of which of the mark' spatial field to be specified. Requires \code{markNames} to be non-\code{NULL} in \code{\link{intModel}}.}

\item{\code{Bias}}{Name of the dataset for which the bias field to be specified.}

\item{\code{PC}}{Logical: should the Matern model be specified with pc priors. Defaults to \code{TRUE}, which uses \code{\link[INLA]{inla.spde2.pcmatern}} to specify the model; otherwise uses \code{\link[INLA]{inla.spde2.matern}}.}

\item{\code{Remove}}{Logical: should the chosen spatial field be removed. Requires one of \code{sharedSpatial}, \code{species}, \code{mark} or \code{bias} to be non-missing, which chooses which field to remove.}

\item{\code{...}}{Additional arguments used by \pkg{INLA}'s \code{\link[INLA]{inla.spde2.pcmatern}} or \code{\link[INLA]{inla.spde2.matern}} function, dependent on the value of \code{PC}.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ if (requireNamespace('INLA')) {
   
 #Get Data
 data("SolitaryTinamou")
 proj <- CRS("+proj=longlat +ellps=WGS84")
 data <- SolitaryTinamou$datasets
 mesh <- SolitaryTinamou$mesh
 mesh$crs <- proj
 Forest <- SolitaryTinamou$covariates$Forest
 
 
 #Set model up
 organizedData <- intModel(data, Mesh = mesh, Coordinates = c('X', 'Y'),
                           spatialCovariates = Forest,
                           Projection = proj, responsePA = 'Present')

 #Specify the shared spatial field
 organizedData$specifySpatial(sharedSpatial = TRUE, PC = TRUE, 
                       prior.range = c(1,0.001),
                       prior.sigma = c(1,0.001))

} 
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dataSDM-changeLink"></a>}}
\if{latex}{\out{\hypertarget{method-dataSDM-changeLink}{}}}
\subsection{Method \code{changeLink()}}{
Function used to change the link function for a given process.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dataSDM$changeLink(datasetName, Species, Mark, Link, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{datasetName}}{Name of the dataset for which the link function needs to be changed.}

\item{\code{Species}}{Name of the species for which the link function needs to be changed.}

\item{\code{Mark}}{Name of the mark for which the link function needs to be changed.}

\item{\code{Link}}{Name of the link function to add to the process. If missing, will print the link function of the specified dataset.}

\item{\code{...}}{Not used}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{

#Create data object
dataObj <- intModel(...)

#Print link function for a process

dataObj$changeLink(Dataset = Dataset, Species = Species)

#Change link function
dataObj$changeLink(Dataset = Dataset, Species = Species,
                   Link = "log")

}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dataSDM-spatialBlock"></a>}}
\if{latex}{\out{\hypertarget{method-dataSDM-spatialBlock}{}}}
\subsection{Method \code{spatialBlock()}}{
Function to spatially block the datasets, which will then be used for model cross-validation with \code{\link{blockedCV}}. See the \code{\link[blockCV]{spatialBlock}} function from \pkg{blockCV} for how the spatial blocking works and for further details on the function's arguments.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dataSDM$spatialBlock(k, rows, cols, plot = FALSE, seed = 1234, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{k}}{Integer value reflecting the number of folds to use.}

\item{\code{rows}}{Integer value by which the area is divided into latitudinal bins.}

\item{\code{cols}}{Integer value by which the area is divided into longitudinal bins.}

\item{\code{plot}}{Plot the cross-validation folds as well as the points across the boundary. Defaults to \code{FALSE}.}

\item{\code{seed}}{Seed used by \pkg{blockCV}'s \code{\link[blockCV]{spatialBlock}} to make the spatial blocking reproducible across different models. Defaults to \code{1234}.}

\item{\code{...}}{Additional arguments used by \pkg{blockCV}'s \code{\link[blockCV]{spatialBlock}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ if (requireNamespace('INLA')) {
   
 #Get Data
 data("SolitaryTinamou")
 proj <- CRS("+proj=longlat +ellps=WGS84")
 data <- SolitaryTinamou$datasets
 mesh <- SolitaryTinamou$mesh
 mesh$crs <- proj
 Forest <- SolitaryTinamou$covariates$Forest
 
 
 #Set model up
 organizedData <- intModel(data, Mesh = mesh, Coordinates = c('X', 'Y'),
                           spatialCovariates = Forest,
                           Projection = proj, responsePA = 'Present',
                           pointsSpatial = 'individual')

 #Specify the spatial block
 organizedData$spatialBlock(k = 2, rows = 2, cols = 1, plot = TRUE)

} 

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dataSDM-new"></a>}}
\if{latex}{\out{\hypertarget{method-dataSDM-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dataSDM$new(
  coordinates,
  projection,
  Inlamesh,
  initialnames,
  responsecounts,
  responsepa,
  marksnames,
  marksfamily,
  pointcovariates,
  trialspa,
  trialsmarks,
  speciesname,
  marksspatial,
  spatial,
  intercepts,
  spatialcovariates,
  marksintercepts,
  boundary,
  ips,
  temporal,
  temporalmodel,
  speciesspatial,
  offset
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dataSDM-samplingBias"></a>}}
\if{latex}{\out{\hypertarget{method-dataSDM-samplingBias}{}}}
\subsection{Method \code{samplingBias()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dataSDM$samplingBias(datasetName, Samplers)}\if{html}{\out{</div>}}
}

}
}
