% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Echidna_data.R
\docType{data}
\name{one_spot_df}
\alias{one_spot_df}
\title{one_spot_df}
\format{
A data frame with 32 rows and 6 variables:
\describe{
  \item{pattern}{Character array where each entry corresponds to a 5 base motif. The
  mutation probabilities correspond to the middle nucleotide in each 5mer.}
  \item{toA}{The probability for the middle nucleotide in "pattern" to mutate to an adenine}
  \item{toC}{The probability for the middle nucleotide in "pattern" to mutate to an cytosine}
  \item{toG}{The probability for the middle nucleotide in "pattern" to mutate to an guanine}
  \item{toT}{The probability for the middle nucleotide in "pattern" to mutate to an thymine}
  \item{Source}{The origin of how this motif was discovered. Either Inferred or Experimental}
}
}
\source{
Yaari et al., Frontiers in Immunology, 2013
}
\usage{
data("one_spot_df")
}
\description{
WRC hotspot mutations taken from Yaari et al., Frontiers in Immunology, 2013.
These include only the mutations following the WRC pattern,
where W equals A or T and R equals A or G). Custom mutation hotspots can be supplied
by modifying this dataframe. Repeating particular hotspot entries allows
for the hotspot to mutate more than one time per SHM event.
}
\keyword{datasets}
