% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ellipse.R
\name{fitEllipse}
\alias{fitEllipse}
\title{Fit an ellipse}
\usage{
fitEllipse(points)
}
\arguments{
\item{points}{numeric matrix with two columns, one point per row}
}
\value{
An \code{Ellipse} object representing the fitted ellipse. The
  residual sum of squares is given in the \code{RSS} attribute.
}
\description{
Fit an ellipse to a set of points.
}
\examples{
library(PlaneGeometry)
# We add some noise to 30 points on an ellipse:
ell <- Ellipse$new(c(1, 1), 3, 2, 30)
set.seed(666L)
points <- ell$randomPoints(30, "on") + matrix(rnorm(30*2, sd = 0.2), ncol = 2)
# Now we fit an ellipse to these points:
ellFitted <- fitEllipse(points)
# let's draw all this stuff:
box <- ell$boundingbox()
plot(NULL, asp = 1, xlim = box$x, ylim = box$y, xlab = NA, ylab = NA)
draw(ell, border = "blue", lwd = 2)
points(points, pch = 19)
draw(ellFitted, border = "green", lwd = 2)
}
