% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Forest_seg.R
\name{Forest_seg}
\alias{Forest_seg}
\title{Forest component segmentation}
\usage{
Forest_seg (a, filename="XXX", dimVox = 2, th = 2,
eps = 2, mpts = 6, h_tree = 1, soil_dim= 0.3,
N = 500, R = 30, Vox_print = FALSE, WoodVox_print = FALSE, output_path = tempdir())
}
\arguments{
\item{a}{- Input file (.xyz)}

\item{filename}{- Output file prefix}

\item{dimVox}{- Voxel dimension (cm) - Default = 2}

\item{th}{- Minimum number of point to generate a voxel. Default = 2}

\item{eps}{- size (radius) of the epsilon neighborhood - Default = 1}

\item{mpts}{- number of minimum points required in the eps neighborhood for core points (including the point itself) - Default = 4}

\item{h_tree}{- minumum trunk lenght (m)}

\item{soil_dim}{- Voxel dimension (m) for forest floor segmentation - Default = 0.30}

\item{N}{- Minimum number of voxel in a wood cluster - Default = 1000}

\item{R}{- R = Standard deviation * Proportion of Variance - Default = 30}

\item{Vox_print}{- Print point cloud voxelization. Default FALSE}

\item{WoodVox_print}{- Print wood voxelization}

\item{output_path}{Directory in cui scrivere i file di output. Default = tempdir()}
}
\value{
6 files (.txt) output. 1. Voxelized pointcloud. 2. Forest floor (vox). 3. AGB (vox) 4. DTM. 5. Wood (vox) 6. AGB no wood
}
\description{
Segments the input .xyz pointcloud file into different forestry layers.
}
\details{
Whole pointcloud segmentation process
}
