% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_modification.R
\name{obtain_mod_Spectronaut}
\alias{obtain_mod_Spectronaut}
\title{Obtain modification information from Peptide data generated by Spectronaut}
\usage{
obtain_mod_Spectronaut(
  data,
  column,
  PTM_table = NULL,
  PTM_annotation = FALSE,
  PTM_mass_column
)
}
\arguments{
\item{data}{A data.table with a column containing modified peptide sequences.}

\item{column}{The name of the column containing the modified peptide sequences.}

\item{PTM_table}{A data.table with columns 'PTM_mass' and 'PTM_type' containing PTM annotation information.}

\item{PTM_annotation}{A logical value indicating whether to include PTM annotation information in the result.}

\item{PTM_mass_column}{The name of the column containing the PTM mass information}
}
\value{
A data.table with 'PTM_position', 'PTM_type', 'reps', and other columns.
}
\description{
This function takes Spectronaut output containing a column with modified peptide sequences
including PTM information and converts it into a new dataframe with the desired format of peptide
sequences and associated PTM information.
}
\examples{
library(data.table)
data <- data.table(
  EG.ModifiedPeptide = c(
    "_[Acetyl (Protein N-term)]M[Oxidation (M)]DDREDLVYQAK_",
    "_EAAENSLVAYK_",
    "_IEAELQDIC[Carbamidomethyl (C)]NDVLELLDK_"
  ),
  Condition = c("A", "B", "B")
)
PTM_table <- data.table(
  PTM_mass = c(
    'Acetyl (Protein N-term)',
    'Oxidation (M)',
    'Carbamidomethyl (C)'
  ),
  PTM_type = c("Acet", "Ox", "Cam")
)
converted_data <- obtain_mod_Spectronaut(data, 'EG.ModifiedPeptide',
                                         PTM_table, PTM_annotation = TRUE,
                                         PTM_mass_column = "PTM_mass")
data <- data.table(
  EG.IntPIMID = c(
    "_[+42]M[-0.98]DDREDLVYQAK_",
    "_EAAENSLVAYK_",
    "_IEAELQDIC[+57]NDVLELLDK_"
  ),
  Condition = c("A", "B", "B")
)
PTM_table <- data.table(PTM_mass = c(42, -0.98, 57),
                        PTM_type = c("Acet", "Amid", "Cam"))
PTM_mass_column <- "PTM_mass"
converted_data <- obtain_mod_Spectronaut(data,
                                         'EG.IntPIMID',
                                         PTM_table,
                                         PTM_annotation = TRUE,
                                         PTM_mass_column)

}
