% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alphaTesting.R
\name{alphaTesting}
\alias{alphaTesting}
\title{Testing the difference of alpha outperformance ratios}
\usage{
alphaTesting(x, y, factors = NULL, control = list(), screen_beta = FALSE)
}
\arguments{
\item{x}{Vector (of length \eqn{T}) of returns for the first fund. \code{NA}
values are allowed.}

\item{y}{Vector (of length \eqn{T}) returns for the second fund. \code{NA}
values are allowed.}

\item{factors}{Matrix \eqn{(T \times K)}{(TxK)} of \eqn{T} returns for the
\eqn{K} factors. \code{NA} values are allowed.}

\item{control}{Control parameters (see *Details*).}

\item{screen_beta}{Boolean to screen all factors' coefficients (beta).
Default: \code{screen_beta=FALSE} (i.e. only outputs the alpha).
If \code{screen_beta=TRUE}, each element of the returned list will have a new first dimension
representing each coefficient (the first one being alpha)}
}
\value{
A list with the following components:\cr

\code{n}: Number of non-\code{NA} concordant observations.\cr

\code{alpha}: Vector (of length 2) of unconditional alpha outperformance ratios.\cr

\code{dalpha}: alpha outperformance ratios difference.\cr

\code{tstat}: t-stat of alpha outperformance ratios differences.\cr

\code{pval}: pvalues of test of alpha outperformance ratios differences.
}
\description{
Function which performs the testing of the difference of alpha outperformance ratios.
}
\details{
The alpha measure (Treynor and Black 1973, Carhart 1997, Fung and Hsieh
2004) is one industry standard for measuring the absolute risk adjusted
performance of hedge funds. This function performs
the testing of alpha outperformance ratio difference for two funds.

For the testing, only the intersection of non-\code{NA} observations for the
two funds are used.

The argument \code{control} is a list that can supply any of the following
components:
\itemize{
\item \code{'hac'} Heteroscedastic-autocorrelation consistent
standard errors. Default: \code{hac = FALSE}.
}
}
\note{
Further details on the methodology with an application to the hedge
fund industry is given in in Ardia and Boudt (2018).

Some internal functions where adapted from Michael Wolf MATLAB code.
}
\examples{
## Load the data (randomized data of monthly hedge fund returns)
data("hfdata")
x = hfdata[,1]
y = hfdata[,2]

## Run alpha testing
alphaTesting(x, y)
}
\references{
Ardia, D., Boudt, K. (2015).
Testing equality of modified Sharpe ratios.
\emph{Finance Research Letters} \bold{13}, 97--104.

Ardia, D., Boudt, K. (2018).
The peer performance ratios of hedge funds.
\emph{Journal of Banking and Finance} \bold{87}, 351--368.

Barras, L., Scaillet, O., Wermers, R. (2010).
False discoveries in mutual fund performance: Measuring luck in estimated alphas.
\emph{Journal of Finance} \bold{65}(1), 179--216.

Sharpe, W.F. (1994).
The Sharpe ratio.
\emph{Journal of Portfolio Management} \bold{21}(1), 49--58.

Ledoit, O., Wolf, M. (2008).
Robust performance hypothesis testing with the Sharpe ratio.
\emph{Journal of Empirical Finance} \bold{15}(5), 850--859.

Storey, J. (2002).
A direct approach to false discovery rates.
\emph{Journal of the Royal Statistical Society B} \bold{64}(3), 479--498.
}
\seealso{
\code{\link{alphaScreening}}..
}
\author{
David Ardia and Kris Boudt.
}
\keyword{htest}
