% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDemographics.R
\name{addFutureObservation}
\alias{addFutureObservation}
\title{Compute the number of days till the end of the observation period at a
certain date}
\usage{
addFutureObservation(
  x,
  cdm = lifecycle::deprecated(),
  indexDate = "cohort_start_date",
  futureObservationName = "future_observation",
  futureObservationType = "days"
)
}
\arguments{
\item{x}{Table with individuals in the cdm.}

\item{cdm}{A cdm_reference object.}

\item{indexDate}{Variable in x that contains the date to compute the future
observation.}

\item{futureObservationName}{name of the new column to be added.}

\item{futureObservationType}{Whether to return a "date" or the number of
"days".}
}
\value{
cohort table with added column containing future observation of the
individuals.
}
\description{
Compute the number of days till the end of the observation period at a
certain date
}
\examples{
\donttest{
cdm <- mockPatientProfiles()

cdm$cohort1 \%>\%
  addFutureObservation()
CDMConnector::cdmDisconnect(cdm = cdm)
}
}
