% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtractData.R
\name{createRestrictPlpDataSettings}
\alias{createRestrictPlpDataSettings}
\title{createRestrictPlpDataSettings define extra restriction settings when calling getPlpData}
\usage{
createRestrictPlpDataSettings(
  studyStartDate = "",
  studyEndDate = "",
  firstExposureOnly = FALSE,
  washoutPeriod = 0,
  sampleSize = NULL
)
}
\arguments{
\item{studyStartDate}{A calendar date specifying the minimum date that a cohort index
date can appear. Date format is 'yyyymmdd'.}

\item{studyEndDate}{A calendar date specifying the maximum date that a cohort index
date can appear. Date format is 'yyyymmdd'. Important: the study
end data is also used to truncate risk windows, meaning no outcomes
beyond the study end date will be considered.}

\item{firstExposureOnly}{Should only the first exposure per subject be included? Note that
this is typically done in the \code{createStudyPopulation} function,
but can already be done here for efficiency reasons.}

\item{washoutPeriod}{The mininum required continuous observation time prior to index
date for a person to be included in the at risk cohort. Note that
this is typically done in the \code{createStudyPopulation} function,
but can already be done here for efficiency reasons.}

\item{sampleSize}{If not NULL, the number of people to sample from the target cohort}
}
\value{
A setting object of class \code{restrictPlpDataSettings} containing a list of
the settings: \itemize{
\item{\code{studyStartDate}: A calendar date specifying the minimum date that a cohort index date can appear}
\item{\code{studyEndDate}: A calendar date specifying the maximum date that a cohort index date can appear}
\item{\code{firstExposureOnly}: Should only the first exposure per subject be included}
\item{\code{washoutPeriod}: The mininum required continuous observation time prior to index date for a person to be included in the at risk cohort}
\item{\code{sampleSize}: If not NULL, the number of people to sample from the target cohort}
}
}
\description{
This function creates the settings used to restrict the target cohort when calling getPlpData
}
\details{
Users need to specify the extra restrictions to apply when downloading the target cohort
}
\examples{
# restrict to 2010, first exposure only, require washout period of 365 day
# and sample 1000 people
createRestrictPlpDataSettings(studyStartDate = "20100101", studyEndDate = "20101231", 
firstExposureOnly = TRUE, washoutPeriod = 365, sampleSize = 1000)
}
