% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PanelMatchObject.R
\name{extract.PanelMatch}
\alias{extract.PanelMatch}
\title{Extract matched.set objects from PanelMatch results}
\usage{
\method{extract}{PanelMatch}(pm.object, qoi = NULL)
}
\arguments{
\item{pm.object}{\code{PanelMatch} obect}

\item{qoi}{character, specifying the qoi. Valid inputs include "att", "atc", "art", and NULL. If NULL, function extracts att, art, or atc results if possible. Otherwise, throws an error if ate is specified.}
}
\value{
a \code{matched.set} object
}
\description{
Extract matched.set objects from PanelMatch results
}
\examples{
dem.sub <- dem[dem[, "wbcode2"] <= 100, ]
dem.sub.panel <- PanelData(dem.sub, "wbcode2", "year", "dem", "y")
# create subset of data for simplicity
PM.results <- PanelMatch(panel.data = dem.sub.panel,
                         lag = 4, 
                         refinement.method = "mahalanobis",
                         match.missing = TRUE,
                         covs.formula = ~ I(lag(tradewb, 1:4)) + I(lag(y, 1:4)),
                         size.match = 5, qoi = "att",
                         lead = 0:4, forbid.treatment.reversal = FALSE)
extract(PM.results, qoi = "att")
extract(PM.results) # valid since att is specified
}
