% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PWI.R
\name{PWI}
\alias{PWI}
\title{Function to calculate prize winner indices based on bibliometric data}
\usage{
PWI(
  files,
  pw_pattern = "(BOYACK K)|(KLAVANS R)|(BORNMANN L)|(...",
  method = 1,
  verbosity = 1,
  data_source = "wos",
  data_format = "plaintext"
)
}
\arguments{
\item{files}{character variable or list of character variables that contain(s)
file name(s) of bibliographic data file(s) that are supported by the package
\link{bibliometrix}}

\item{pw_pattern}{character variable (optional parameter) that is passed as
search pattern to the \link{grep} function to identify the prize winners in
the data set}

\item{method}{integer variable (optional parameter) that determines if only
the authors in the dataset with number of papers and co-authors is returned
or if the prize winner index is calculated
0: return only a list with authors, number of papers, and number of co-authorships
1: calculate the prize winner index and return it alongside with number of papers
and number of co-authorships}

\item{verbosity}{level of verbosity (0=quiet and 1=informative)}

\item{data_source}{specifies the data source; this parameter is forwarded to
the function \link{convert2df} from the R package \link{bibliometrix}. The default
value is "wos"; other possible values are: "isi", "scopus", "dimensions", or "pubmed"}

\item{data_format}{specifies the data format; this parameter is forwarded to
the function \link{convert2df} from the R package \link{bibliometrix}. The default
value is "plaintext"; other possible values are: "api", "bibtex", "endnote", "csv",
or "excel"}
}
\value{
data frame of researcher names, PWI value, number of papers, and number of co-authors
}
\description{
This function calculates prize winner indices based on bibliometric data.
The default prize winners are the recipients of the Derek de Solla Price Memorial Medal.
Users can provide recipients of other prizes.
}
\details{
PWI(files=bibliographic_files, pw_pattern = '(BOYACK K)|(KLAVANS R)|(BORNMANN L)|(BAR-ILAN J)|(BARILAN J)|
(WALTMAN L)|(THELWALL M)|(CRONIN B)|(PERSSON O)|(VINKLER P)|(MCCAIN K)|(INGWERSEN P)|
(LEYDESDORFF L)|(ROUSSEAU R)|(EGGHE L)|(GLANZEL W)|(GLAENZEL W)|(MOED H)|(IRVINE J)|
(MARTIN B)|(GRIFFITH B)|(VAN RAAN A)|(VANRAAN A)|(MERTON R)|(SCHUBERT A)|(BROOKES B)|
(NARIN F)|(NALIMOV V)|(BRAUN T)|(MORAVCSIK M)|(GARFIELD E)',
method=1, verbosity=1, data_source='wos', data_format='plaintext')
Only the argument files is necessary. All other arguments are optional.

Literature:
\itemize{
\item Bornmann, L. & Haunschild, R. (in preparation). "Prize Winner Index".
}
}
\examples{
\donttest{
JoI <- PWI('http://andreas-thor.github.io/cre/data/savedrecs_JOI2.txt')
head(JoI)
}
}
