% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_combine.R
\name{monitor_combine}
\alias{monitor_combine}
\title{Combine List of ws_monitor Objects into Single ws_monitor Object}
\usage{
monitor_combine(monitorList)
}
\arguments{
\item{monitorList}{list containing one or more \emph{ws_monitor} objects}
}
\value{
A \emph{ws_monitor} object combining all monitoring data from \code{monitorList}.
}
\description{
Combines a list of one or more \emph{ws_monitor} objects into a single \emph{ws_monitor} object
by merging the \code{meta} and \code{data} dataframes from each object in \code{monitorList}.

When \code{monitorList} contains only two \emph{ws_monitor} objects the \code{monitor_combine()}
function can be used to extend time ranges for monitorIDs that are found in both \emph{ws_monitor}
objects. This can be used to 'grow' a \emph{ws_monitor} object by appending subsequent months
or years. (Note, however, that this can be CPU intensive process.)
}
\examples{
\donttest{
# Fail gracefully if any resources are not available
try({

library(PWFSLSmoke)
initializeMazamaSpatialUtils()

monitorList <- list()
monitorList[[1]] <- airsis_createMonitorObject(20160701, 20161231, 'USFS', '1031')
monitorList[[2]] <- airsis_createMonitorObject(20160701, 20161231, 'USFS', '1032')
monitorList[[3]] <- airsis_createMonitorObject(20160701, 20161231, 'USFS', '1033')
monitorList[[4]] <- airsis_createMonitorObject(20160701, 20161231, 'USFS', '1034')
ws_monitor <- monitor_combine(monitorList)

if ( interactive() ) {
  monitor_leaflet(ws_monitor)
}

}, silent = FALSE)
}
}
\keyword{ws_monitor}
