% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airsisDump_createMonitorObject.R
\name{airsisDump_createMonitorObject}
\alias{airsisDump_createMonitorObject}
\title{Ingest AIRSIS Dump File and Create ws_monitor Object}
\usage{
airsisDump_createMonitorObject(filepath, clusterDiameter = 1000,
  existingMeta = NULL)
}
\arguments{
\item{filepath}{absolute path of the AIRSIS dump file}

\item{clusterDiameter}{diameter in meters used to determine the number of clusters (see \code{addClustering})}

\item{existingMeta}{existing 'meta' dataframe from which to obtain metadata for known monitor deployments}
}
\value{
A \emph{ws_monitor} object with AIRSIS data.
}
\description{
Ingests an  AIRSIS dump file and converts
it into a quality controlled, metadata enhanced \emph{ws_monitor} object
ready for use with all \code{monitor_~} functions.

Steps involved include:

\enumerate{
 \item{ingest CSV text}
 \item{parse CSV text}
 \item{apply quality control}
 \item{apply clustering to determine unique deployments}
 \item{enhance metadata to include: elevation, timezone, state, country, site name}
 \item{reshape dumpfile data into deployment-by-property \code{meta} and and time-by-deployment \code{data} dataframes}
}
}
\note{
Each dump file must contain data for only one type of monitor, e.g. EBAM or E-Sampler.
}
\seealso{
\code{\link{airsisDump_parseData}}

\code{\link{airsis_qualityControl}}

\code{\link{addClustering}}

\code{\link{airsis_createMetaDataframe}}

\code{\link{airsis_createDataDataframe}}
}
\keyword{internal}
