% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_aqi.R
\name{monitor_aqi}
\alias{monitor_aqi}
\title{Calculate hourly NowCast-based AQI values}
\usage{
monitor_aqi(ws_monitor, aqiParameter = "pm25", nowcastVersion = "pm",
  includeShortTerm = FALSE)
}
\arguments{
\item{ws_monitor}{\emph{ws_monitor} object}

\item{aqiParameter}{parameter type; used to define reference breakpointsTable}

\item{nowcastVersion}{character identity specifying the type of nowcast algorithm to be used.
See \code{?monitor_nowcast} for more information.}

\item{includeShortTerm}{calcluate preliminary values starting with the 2nd hour}
}
\description{
Nowcast and AQI algorithms are applied to the data in the ws_monitor object.
}
\examples{
\dontrun{
ws_monitor <- monitor_subset(Northwest_Megafires, tlim=c(20150815,20150831))
aqi <- monitor_aqi(ws_monitor)
monitorPlot_timeseries(aqi, monitorID=aqi$meta$monitorID[1], ylab="PM25 AQI")
}
}
\references{
\url{https://www3.epa.gov/airnow/aqi-technical-assistance-document-may2016.pdf}

\url{https://www.ecfr.gov/cgi-bin/retrieveECFR?n=40y6.0.1.1.6#ap40.6.58_161.g}
}
\keyword{ws_monitor}
