% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncertainty.R
\name{plr_bootstrap_output_from_results}
\alias{plr_bootstrap_output_from_results}
\title{Bootstrap: Resample from individual Models}
\usage{
plr_bootstrap_output_from_results(
  data,
  power_var,
  time_var,
  weight_var,
  by = "month",
  model,
  fraction = 0.65,
  n = 1000
)
}
\arguments{
\item{data}{Result of modeling data with a PLR determining model, i.e.
plr_xbx_model, plr_6k_model, etc.}

\item{power_var}{Variable name of power in the dataframe. Typically power_var}

\item{time_var}{Variable name of time in the dataframe. Typically time_var}

\item{weight_var}{Variable name of weightings in the dataframe. Typically sigma}

\item{by}{String, either "day", "month", or "year". Time over which to perform
\code{\link{plr_yoy_regression}} and \code{\link{plr_weighted_regression}}.}

\item{model}{The name of the model the data has been put through. This
option is only included for the user's benefit in keeping bootstrap outputs
consistent.}

\item{fraction}{The fractional size of the data to be sampled each time.}

\item{n}{The number of resamples to take.}
}
\value{
Returns PLR value and uncertainty calculated with bootstrap of data going into power correction models
}
\description{
The function samples and bootstraps data that has already been
put through a power predictive model. The PLR and Uncertainty are returned in
a dataframe.
}
\examples{
# build var_list

\donttest{
var_list <- plr_build_var_list(time_var = "timestamp",
                               power_var = "power",
                               irrad_var = "g_poa",
                               temp_var = "mod_temp",
                               wind_var = NA)
# Clean Data
test_dfc <- plr_cleaning(test_df, var_list, irrad_thresh = 100,
                         low_power_thresh = 0.01, high_power_cutoff = NA)
                         
# Perform the power predictive modeling step
test_xbx_wbw_res <- plr_xbx_model(test_dfc, var_list, by = "week",
                                  data_cutoff = 30, predict_data = NULL)
                                  
xbx_mbm_plr_result_uncertainty <- plr_bootstrap_output_from_results(test_xbx_wbw_res, 
                                                                    power_var = 'power_var',
                                                                    time_var = 'time_var',
                                                                    weight_var = 'sigma',
                                                                    by = "month", model = 'xbx',
                                                                    fraction = 0.65, n = 10)
}

}
