% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{EvalTest}
\alias{EvalTest}
\alias{EvalTest}
\alias{WCB_TVTest}
\alias{WCB_HETest}
\title{Conduct the evaluation tests.}
\usage{
EvalTest(use, type = c("time-varying", "heterogeneity"), vq = NULL)

WCB_TVTest(use, iB = 100, parallel = F, cpus = 4)

WCB_HETest(use, vq, iB = 100, parallel = F, cpus = 4)
}
\arguments{
\item{use}{an object of the class PSTR, created by \code{\link{EstPSTR}} function.}

\item{type}{a character vector specifying the types of the evaluation tests to be conducted. The value can be taken either or both of \code{"time-varying"} \code{"heterogeneity"}. By default, do both.}

\item{vq}{a vector of a new transition variable for the no remaining nonlinearity test.}

\item{iB}{specify the number of repetitions in the bootstrap procedure. By default, it is 100.}

\item{parallel}{a boolean value showing if the parallel computation is applied.}

\item{cpus}{number of cores used in the parallel computation. The value will be ignored if \code{parallel=F}.}
}
\value{
a new object of the class PSTR containing the results from the evaluation tests.

The return object from \code{EvalTest} contains the following new components:
\item{tv}{a list of the time-varying evaluation tests. The length of the list is the maximal number of switches. Each element of the list corresponds to the time-varying evaluation test results based on different number of switches.}
\item{ht}{a list of the no remaining nonlinearity (no remaining heterogeneity) evaluation tests. The length of the list is the maximal number of switches. Each element of the list corresponds to the time-varying evaluation test results based on different number of switches. The input vector of a new transition variable is used to compute the tests.}

The return object from \code{WCB_TVTest} contains the following new component:
\item{wcb_tv}{a matrix containing the results from the WB and WCB time-varying tests. Each row of the matrix contains the p-value of the WB and WCB tests.}

The return object from \code{WCB_HETest} contains the following new component:
\item{wcb_ht}{a matrix containing the results from the WB and WCB no remaining nonlinearity (heterogeneity) tests. Each row of the matrix contains the p-value of the WB and WCB tests.}
}
\description{
These functions conduct the evaluation tests against two alternatives: 1. the parameters are time-varying and 2. there is remaining nonlinearity (remaining heterogeneity).
}
\details{
\code{EvalTest} implements the evaluation tests.

\code{WCB_TVTest} implements the wild bootstrap (WB) and the wild cluster bootstrap (WCB) evaluation test of no time-varying parameters.

\code{WCB_HETest} implements the wild bootstrap (WB) and the wild cluster bootstrap (WCB) evaluation test of no remaining nonlinearity (no remaining heterogeneity).

The functions need the return value (an object of the class PSTR) from the \code{\link{EstPSTR}}. Note that the PSTR model should be estimated before conducting the evaluation tests. They copy the object, reuse its contents, especially the estimates, to produce the evaluation test results, and then return a new object of the class PSTR. The user can choose to save the return value to a new object or simply to overwrite the object returned from \code{\link{EstPSTR}}. See the example below.

The functions conduct two kinds of evaluation tests.
The first kind of tests does the time-varying evaluation tests.
The second kind of tests does the no remaining nonlinearity (no remaining heterogeneity) evaluation tests based on the vector of a new transition variable that the user input in the arguments.

The results of the evaluation tests include four kinds of tests
\itemize{
  \item \eqn{\chi^2}-version LM test: the LM test with asymptotically \eqn{\chi^2} distribution under the null hypothesis.
  \item F-version LM test: the LM test with asymptotically \eqn{F} distribution under the null hypothesis. The finite sample actual size is supposed to be improved.
  \item \eqn{\chi^2}-version HAC test: the HAC LM test with asymptotically \eqn{\chi^2} distribution under the null hypothesis, which is heteroskedasticity and autocorrelation consistent.
  \item F-version HAC test: the HAC LM test with asymptotically \eqn{F} distribution under the null hypothesis, which is heteroskedasticity and autocorrelation consistent. The finite sample actual size is supposed to be improved.
}

The wild bootstrap (WB) evaluation tests are heteroskedasticity robust, while the wild cluster bootstrap (WCB) ones are both cluster-dependency and heteroskedasticity robust. Cluster-dependency implies that there can be dependency (autocorrelation) within individual, but no correlation across individuals. The WB and WCB tests may take quite a long time to run which depends on the model specification and the number of repetitions \code{iB}. It is strongly recommended to use super-computation server with many cores to run the code instead of a personal computer. The user may first try a small number of repetitions \code{iB} and estimate the time consumed for a larger number of \code{iB}.

The functions never change the existing values in the input PSTR object. They add more values (attributes) into the input object and return.
}
\examples{
\donttest{
pstr = NewPSTR(Hansen99, dep='inva', indep=4:20, indep_k=c('vala','debta','cfa','sales'),
    tvars=c('vala'), iT=14) # create a new PSTR object

# Estimate the model first
pstr = EstPSTR(use=pstr, im=1, iq=1, useDelta=TRUE, par=c(1.6,.5), method='CG')

# Then you can evaluate the model
pstr = EvalTest(use=pstr, vq=pstr$mQ[,1])

print(pstr, "eval")

# You can do the wild bootstrap and wild cluster bootstrap

library(snowfall)

pstr = WCB_TVTest(use=pstr, iB=4, parallel=TRUE, cpus=2)

# pstr$mQ[,1] is the transition variable stored in the object
# You can also try other transition variables.
pstr = WCB_HETest(use=pstr, vq=pstr$mQ[,1], iB=4, parallel=TRUE, cpus=2)

print(pstr, "eval")

# Don't forget to change the values of iB and cpus during experiments.
}

}
\seealso{
\code{\link{NewPSTR}}, \code{\link{LinTest}}, \code{\link{WCB_LinTest}} and \code{\link{EstPSTR}}
}
\author{
Yukai Yang, \email{yukai.yang@statistik.uu.se}
}
\keyword{evaluation}
