% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DWTPSSM.R
\name{dwt_PSSM}
\alias{dwt_PSSM}
\title{discrete wavelet transform feature vector}
\usage{
dwt_PSSM(pssm_name)
}
\arguments{
\item{pssm_name}{name of pssm Matrix file}
}
\value{
feature vector of length 80
}
\description{
In construction of this feature vector, the \code{\link[waveslim]{dwt.nondyadic}} function is used from
"waveslim", package
to calculate the discrete wavelet transform for each column of the PSSM matrix, which considers it as a
discrete signal. At last, 4 levels DWT is used to analysis of these discrete signals of PSSM (each column) and
extracted the PSSM-DWT feature from PSSM of protein.
}
\examples{
as<-dwt_PSSM(system.file("extdata", "C7GQS7.txt.pssm", package="PSSMCOOL"))
}
\references{
Y. Wang, Y. Ding, F. Guo, L. Wei, and J. J. P. o. Tang, "Improved detection of DNA-binding proteins
via compression technology on PSSM information," vol. 12, no. 9, 2017.

Y. Wang, Y. Ding, J. Tang, Y. Dai, F. J. I. A. t. o. c. b. Guo, and bioinformatics, "CrystalM: a
multi-view fusion approach for protein crystallization prediction," 2019.
}
