% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSPMequi.R
\name{PSPMequi}
\alias{PSPMequi}
\title{Bifurcation analysis of a structured population model}
\usage{
PSPMequi(
  modelname = NULL,
  biftype = NULL,
  startpoint = NULL,
  stepsize = NULL,
  parbnds = NULL,
  parameters = NULL,
  options = NULL,
  clean = FALSE,
  force = FALSE,
  debug = FALSE,
  silent = FALSE
)
}
\arguments{
\item{modelname}{(string, required)
\preformatted{}
              Basename of the file with the model specification. The file
              should have an extension ".h". For example, the model "PNAS2002"
              is specified in the file "PNAS2002.h". If the model is specified 
              in R include the .R extension explicitly, i.e. specify the model
              name as "PNAS2002.R"}

\item{biftype}{(string, required)
\preformatted{}
              Type of bifurcation to compute: "BP", "BPE", "EQ", "LP", "ESS" or "PIP"}

\item{startpoint}{(row vector, required)
\preformatted{}
              The initial point from which to start the continuation of
              the curve}

\item{stepsize}{(double value, required)
\preformatted{}
              Value of the step size in the first bifurcation parameter}

\item{parbnds}{(row vector, required)
\preformatted{}
              Vector of length 3 for EQ continuation, length 6 for BP, BPE, 
              LP and PIP continuation and 3+4*N for ESS continuation.
              The first triplet specifies:
              Each triples specifies:

\preformatted{}
              \verb{parbnds[1]}: the index of the first bifurcation parameter
                          (in case the model is specified in R, this can be
                          a string with the name of the parameter as specified
                          in the variable 'DefaultParameters')
\preformatted{}
              \verb{parbnds[2]}: lower threshold, below which value of the
                          first bifurcation parameter the computation stops
\preformatted{}
              \verb{parbnds[3]}: upper threshold, above which value of the
                          first bifurcation parameter the computation stops
\preformatted{}
              In case of two-parameter bifurcations, the second triplet specifies:
\preformatted{}
              \verb{parbnds[4]}: the index of the second bifurcation parameter
                          (in case the model is specified in R, this can be
                           a string with the name of the parameter as specified
                           in the variable 'DefaultParameters')
\preformatted{}
              \verb{parbnds[5]}: lower threshold, below which value of the
                          second bifurcation parameter the computation stops
\preformatted{}
              \verb{parbnds[6]}: upper threshold, above which value of the
                          second bifurcation parameter the computation stops

              In case of ESS continuation, consecutive sets of 4 values specify:

              \verb{parbnds[4*n]}:   the index of population that is impacted by the
                          parameter at its ESS value
                          (in case the model is specified in R, this can be
                           a string with the name of the parameter as specified
                           in the variable 'DefaultParameters')
              \verb{parbnds[4*n+1]}: the index of the parameter at its ESS value
              \verb{parbnds[4*n+2]}: lower threshold, below which value of this ESS
                          parameter the computation stops
              \verb{parbnds[4*n+3]}: upper threshold, above which value of this ESS
                          parameter the computation stops}

\item{parameters}{(row vector, optional, can be left equal to its default NULL)
\preformatted{}
              Vector of length PARAMETER_NR (set in the model program
              file; This is the length of the variable 'DefaultParameters' if the
              model is specified in R), specifying the values for the model
              parameters to use in the computation. Vectors of other lengths,
              including an empty vector will be ignored.}

\item{options}{(row vector of strings, optional, can be left equal to its default NULL)
\preformatted{}
              Vector with pairs of strings, consisting of an option name and a value (for
              example c("popBP", "1")) or single options (i.e. c("test")).
              Possible option names and their values are:
\preformatted{}
              \verb{"envBP", "<index>"}: Index of environment variable, of which
                                   to continue the transcritical bifurcation
\preformatted{}
              \verb{"popBP", "<index>"}: Index of structured population, of which
                                   to continue the transcritical bifurcation
\preformatted{}
              \verb{"popEVO", "<index>"}: Index of structured population, for
                                   which to compute the selection gradient or
                                   perform PIP continuation
\preformatted{}
              \verb{"parEVO", "<index>"}: Index of parameter, for which to
                                   compute the selection gradient
\preformatted{}
              \verb{"envZE", "<index>"}: Index of environment variable in
                                   trivial equilibrium (can be used
                                   multiple times)
\preformatted{}
              \verb{"popZE", "<index>"}: Index of structured population in
                                   trivial equilibrium (can be used
                                   multiple times)
\preformatted{}
              \verb{"isort", "<index>"}: Index of i-state variable to use as
                                   ruling variable for sorting the
                                   structured populations
\preformatted{}
              \verb{"report", "<value>"}: Interval between consecutive output of 
                                   computed points to the console ( >= 1). 
                                   Minimum value of 1 implies output of every 
                                   point
\preformatted{}
              \verb{"noBP"}: Do not check for branching points while
                                   computing equilibrium curves
\preformatted{}
              \verb{"noLP"}: Do not check for limit points while
                                   computing equilibrium curves
\preformatted{}
              \verb{"single"}: Only compute the first point of the
                                   solution curve, do not continue the curve
\preformatted{}
              \verb{"test"}: Perform only a single integration over
                                   the life history, reporting dynamics
                                   of survival, R0, i-state and
                                   interaction variables}

\item{clean}{(Boolean, optional argument)
\preformatted{}
              Specify clean = TRUE as argument to remove all the result files
              of the model before the computation}

\item{force}{(Boolean, optional argument)
\preformatted{}
              Specify force = TRUE as argument to force a rebuilding of the model
              before the computation}

\item{debug}{(Boolean, optional argument)
\preformatted{}
              Specify debug = TRUE as argument to compile the model in verbose
              mode and with debugging flag set}

\item{silent}{(Boolean, optional argument)
\preformatted{}
              Specify silent = TRUE as argument to suppress reporting of compilation
              commands and results on the console}
}
\value{
The output is a list containing the following elements:
\preformatted{}
  \verb{curvepoints}: Matrix with output for all computed points along the curve
\preformatted{}
  \verb{curvedesc}:   Column vector with strings, summarizing the numerical details
               of the computed curve (i.e., initial point, parameter values,
               numerical settings used)
\preformatted{}
  \verb{bifpoints}:   Matrix with the located bifurcation points along the curve
\preformatted{}
  \verb{biftypes}:    Column vector of strings, containing a description of the
               type of bifurcation for each of the located bifurcation points
}
\description{
\code{PSPMequi} computes bifurcation curves for a physiologically structured
population model as a function of one or two parameters and detects bifurcation
points along these curves.
When computing equilibrium curves of a physiologically structured population model
as a function of one parameter, \code{PSPMequi} can detect transcritical
bifurcation points (branching points, BP) of both the structured populations as
well as environment variables (BPE), limit points (LP) in the equilibrium curve
and evolutionary stationary points (ESS). The location of these bifurcation points
can subsequently be computed as a function of second parameter.
In addition \code{PSPMequi} can compute the pairwise invasion plot (PIP) as a
function of the resident and a mutant value for one evolving parameter.
}
\details{
output <- PSPMequi(modelname = NULL, biftype = NULL, startpoint = NULL,
                     stepsize = NULL, parbnds = NULL, parameters = NULL,
                     options = NULL, clean = FALSE, force  = FALSE,
                     debug  = FALSE, silent = FALSE)
}
\examples{
\dontrun{
PSPMequi("Indet_growth", "EQ", c(1, 0.22, 0), -0.1, c(6, 0.8, 1.0),
         options = c("popEVO", "0"), silent = TRUE)
}

}
