% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRS_Dis_CT.R
\name{PRS_Dis_CT}
\alias{PRS_Dis_CT}
\title{Construct disease PRS unadjusted or using clumping and thresholding}
\usage{
PRS_Dis_CT(
  DIS_GWAS,
  G_reference,
  pcutoff = 1e-05,
  clumping = TRUE,
  p1 = 1e-04,
  d1 = 250000,
  r1 = 0.8
)
}
\arguments{
\item{DIS_GWAS}{a numeric matrix containing disease GWAS summary statistics, including SNP ID, position, \eqn{\beta}, SE(\eqn{\beta}), p-value, N, and MAF}

\item{G_reference}{a numeric matrix containing the individual-level genotype information from the reference panel (e.g., 1KG)}

\item{pcutoff}{a numeric value indicating the p-value cutoff}

\item{clumping}{a logical flag indicating should clumping be performed}

\item{p1}{a numeric value indicating p-value threshold to decide flag SNPs in clumping}

\item{d1}{a numeric value indicating window size in clumping}

\item{r1}{a numeric value indicating correlation in clumping}
}
\value{
A numeric list, the first sublist contains estimated prognostic effect sizes, the second sublist contains estimated predictive effect sizes
}
\description{
Shrink prognostic effect sizes by p-value cutoff (PRS-Dis-CT turns out to be PRS-Dis-Unadj when setting p-value cutoff = 1)
}
\details{
PRS-Dis-CT automatically sets predictive effect sizes equivalent to the prognostic effect sizes; and only need disease GWAS summary statistics
}
\examples{
data(PRSPGx.example); attach(PRSPGx.example)
coef_est <- PRS_Dis_CT(DIS_GWAS, G_reference, pcutoff = 0.01, clumping = TRUE)
summary(coef_est$coef.G)
summary(coef_est$coef.TG)

}
\references{
Euesden, J., Lewis, C.M. & O'Reilly, P.F. PRSice: Polygenic Risk Score software. Bioinformatics 564, 1466-1468 (2015).

Zhai, S., Zhang, H., Mehrotra, D.V. & Shen, J. Paradigm Shift from Disease PRS to PGx PRS for Drug Response Prediction using PRS-PGx Methods (submitted).
}
\author{
Song Zhai
}
