% Generated by roxygen2 (4.0.1): do not edit by hand
\name{PV}
\alias{PV}
\alias{PV.fourpl}
\alias{PV.gpcm}
\alias{PV.gpcm4pl}
\alias{print.pv}
\alias{summary.pv}
\title{Draw Plausible values}
\usage{
PV(estobj, ...)

\method{PV}{fourpl}(estobj, npv = 10, approx = TRUE, thinning = 6,
  burnin = 10, mult = 2, ...)

\method{PV}{gpcm}(estobj, npv = 10, approx = TRUE, thinning = 6,
  burnin = 10, mult = 2, ...)

\method{PV}{gpcm4pl}(estobj, npv = 10, approx = TRUE, thinning = 6,
  burnin = 10, mult = 2, ...)

\method{print}{pv}(x, ...)

\method{summary}{pv}(object, nrowmax = 15, ...)
}
\arguments{
\item{estobj}{An object which originates from using \code{PP_4pl()}, \code{PP_gpcm()} or \code{PPall()}. EAP estimation is strongly recommended (\code{type = "eap"}), when plausible values are drawn afterwards, because the EAP estimate is used as starting point for the MH algorithm.}

\item{npv}{The number of (effectively returned) plausible values - default is 10.}

\item{approx}{Whether a normal approximation \code{N(mu,sigma2)} is used to draw the plausible values. Default = TRUE. If FALSE a Metropolitan-Hastings-Algorithm will draw the values.}

\item{thinning}{A numeric vector of length = 1. If approx = FALSE, a Metropolitan-Hastings-Algorithm draws the plausible values. To avoid autocorrelation, thinning takes every \bold{kth} value as effective plausible value. The default is 6 (every 6th value is taken), which works appropriately in almost all cases here (with default settings).}

\item{burnin}{How many draws should be discarded at the chains beginning? Default is 10 - and this seems reasonable high (probably 5 will be enough as well), because starting point is the EAP.}

\item{mult}{Multiplication constant (default = 2). Use this parameter to vary the width of the proposal distribution - which is \code{N(theta_v,mult*SE_eap)} - when a MH-Algorithm is applied. So the constant quantifies the width in terms of multiples of the EAP standard error. 2 works fine with the default thinning. If the supplied value is large, thinning can take lower values without causing autocorrelation.}

\item{...}{More arguments}

\item{x}{An object of class \code{pv} which is the result of using the \code{PV()} function}

\item{object}{An object of class \code{pv} which is the result of using the \code{PV()} function}

\item{nrowmax}{When printing the matrix of estimates - how many rows should be shown? Default = 15.}
}
\value{
The function returns a list which main element is \code{pvdraws}. This is a matrix of size number_of_persons x npv - so if 10 plausible values are requested for 100 persons, a 100x10 matrix is returned.
}
\description{
This function draws \code{npv} plausible values for each person from their posterior density.
}
\examples{
################# Plausible values #############################################################


### 4 PL model ######


### data creation ##########

set.seed(1522)
# intercepts
diffpar <- seq(-3,3,length=12)
# slope parameters
sl     <- round(runif(12,0.5,1.5),2)
la     <- round(runif(12,0,0.25),2)
ua     <- round(runif(12,0.8,1),2)

# response matrix
awm <- matrix(sample(0:1,10*12,replace=TRUE),ncol=12)


# EAP estimation - 2pl model
res2pleap <- PP_4pl(respm = awm,thres = diffpar, slopes = sl,type = "eap")

# draw 10 plausible values
res_pv  <- PV(res2pleap)
summary(res_pv)

# draw 10 plausible values - use a metropolitan hastings algorithm
res_pv2  <- PV(res2pleap,approx = FALSE)
summary(res_pv2)

# ------ check the PVs


# -- autocorrelation?
autocor <- function(acv)
  {
  cor(acv[-1],acv[-length(acv)]) 
  }


res_pvac  <- PV(res2pleap,approx = FALSE,npv = 200)

# independent draws - so there cannot be any systematic autocorrelation when
# approx = TRUE. So this acts as a kind of benchmark for the MH-Alg.
res_pvac2  <- PV(res2pleap,approx = TRUE,npv = 200)

apply(res_pvac$pvdraws,1,autocor)
apply(res_pvac2$pvdraws,1,autocor)

# -- autocorrelation distr?


apply(res_pvac$pvdraws,1,quantile)
apply(res_pvac2$pvdraws,1, quantile)




### GPCM model ######


# some threshold parameters
THRES  <- matrix(c(-2,-1.23,1.11,3.48,1
                   ,2,-1,-0.2,0.5,1.3,-0.8,1.5),nrow=2)
# slopes
sl     <- c(0.5,1,1.5,1.1,1,0.98)
awmatrix <- matrix(c(1,0,2,0,1,1,1,0,0,1
                     ,2,0,0,0,0,0,0,0,0,1,1,2,2,1,1,1,1,0,0,1),byrow=TRUE,nrow=5)


# EAP estimation
resgpcmeap <- PP_gpcm(respm = awmatrix,thres = THRES, slopes = sl,type = "eap")


res_gpcmpv  <- PV(resgpcmeap,approx = FALSE,npv = 20)




### GPCM and 4PL model ######


# some threshold parameters
THRES  <- matrix(c(-2,-1.23,1.11,3.48,1
                   ,2,-1,-0.2,0.5,1.3,-0.8,1.5),nrow=2)
# slopes
sl     <- c(0.5,1,1.5,1.1,1,0.98)

THRESx <- THRES
THRESx[2,1:3] <- NA

# for the 4PL item the estimated parameters are submitted, 
# for the GPCM items the lower asymptote = 0 
# and the upper asymptote = 1.
la     <- c(0.02,0.1,0,0,0,0)
ua     <- c(0.97,0.91,1,1,1,1)

awmatrix <- matrix(c(1,0,1,0,1,1,1,0,0,1
                     ,2,0,0,0,0,0,0,0,0,1
                     ,1,2,2,1,1,1,1,0,0,1),byrow=TRUE,nrow=5)

model2est <- findmodel(THRESx)


# EAP estimation
respcmeap1 <- PPall(respm = awmatrix,thres = THRESx, 
                    slopes = sl,lowerA = la, upperA=ua, type = "eap",
                    model2est=model2est)


res_mixedpv_1  <- PV(respcmeap1,approx = FALSE,npv = 200)

# rowMeans of plausible values should approximate the EAPs
rowMeans(res_mixedpv_1$pvdraws)
# EAPs
respcmeap1

# show the quantiles of the empirical distribution
apply(res_mixedpv_1$pvdraws,1,quantile)

}
\author{
Manuel Reif
}
\references{
Mislevy, R. J. (1991). Randomization-based inference about latent variables from complex samples. Psychometrika, 56(2), 177-196.

Von Davier, M., Gonzalez, E., & Mislevy, R. (2009). What are plausible values and why are they useful. IERI monograph series, 2, 9-36.

Kruschke, J. (2010). Doing Bayesian data analysis: A tutorial introduction with R. Academic Press.
}
\seealso{
\link{PP_gpcm}, \link{PP_4pl}, \link{JKpp}
}

