.validity_PvMethod_Liu <- function(object) {

  if (length(x = object@args) == 0L) return( TRUE )

  liuArgs <- names(x = formals(fun = liu))

  if (!all(names(x = object@args) %in% liuArgs)) {
    return( "arguments provided do not match call to liu" )
  }

  return( TRUE )
}

# Class \code{PvMethod_Liu}
#
# Class \code{PvMethod_Liu} stores arguments for p-value method using liu
#
# @name PvMethod_Liu-class
# 
# @keywords internal
#
# @include B_PvMethod.R
#
setClass(Class = "PvMethod_Liu",
         contains = c("PvMethod"),
         prototype = list(args = list()),
         validity = .validity_PvMethod_Liu)

# @rdname calcPV
setMethod(f = ".calcPV",
          signature = c(method = "PvMethod_Liu"),
          definition = function(method, psi, ev, ...) {

              argList <- method@args
              argList[[ "q" ]] <- .Ts(psi = psi)
              argList[[ "lambda" ]] <- ev   

              res <- tryCatch(expr = do.call(what = liu,
                                             args = argList),
                              error = function(e){
                                        print(x = e$message)
                                        stop("error generated by CompQuadForm::liu", call. = FALSE)
                                      },
                              warning = function(w){
                                        print(x = paste("From CompQuadForm::liu:", w$message))
                                      })
              return( res )
            })
