% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grubbsTest.R
\name{grubbsTest}
\alias{grubbsTest}
\title{Grubbs Outlier Test}
\usage{
grubbsTest(x, alternative = c("two.sided", "greater", "less"))
}
\arguments{
\item{x}{a numeric vector of data.}

\item{alternative}{the alternative hypothesis.
Defaults to \code{"two.sided"}.}
}
\value{
A list with class \code{"htest"} containing the following components:
\describe{
\item{method}{a character string indicating what type of test was performed.}
\item{data.name}{a character string giving the name(s) of the data.}
\item{statistic}{the estimated quantile of the test statistic.}
\item{p.value}{the p-value for the test.}
\item{parameter}{the parameters of the test statistic, if any.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{estimates}{the estimates, if any.}
\item{null.value}{the estimate under the null hypothesis, if any.}
}
}
\description{
Performs Grubbs single outlier test.
}
\details{
Let \eqn{X} denote an identically and independently distributed continuous
variate with realizations \eqn{x_i ~~ (1 \le i \le k)}.
Further, let the increasingly ordered realizations
denote \eqn{x_{(1)} \le x_{(2)} \le \ldots \le x_{(n)}}. Then
the following model for a single maximum outlier can be proposed:

\deqn{
  x_{(i)} = \left\{
      \begin{array}{lcl}
       \mu + \epsilon_{(i)}, & \qquad & i = 1, \ldots, n - 1 \\
       \mu + \Delta + \epsilon_{(n)} & & \\
      \end{array} \right.}{%
  x[(i)] = \mu + \epsilon[(i)] for i = 1, ..., n - 1
and x[(i)] = \mu + \Delta + \epsilon[(n)]}

with \eqn{\epsilon \approx N(0,\sigma)}. The null hypothesis,
H\eqn{_0: \Delta = 0} is tested against the alternative,
H\eqn{_{\mathrm{A}}: \Delta > 0}.

For testing a single minimum outlier, the model can be proposed
as

\deqn{
  x_{(i)} = \left\{
      \begin{array}{lcl}
       \mu + \Delta + \epsilon_{(1)} & & \\
       \mu + \epsilon_{(i)}, & \qquad & i = 2, \ldots, n \\
      \end{array} \right.}{%
  x[(i)] = \mu + \Delta + \epsilon[(1)]
  and x[(i)] = \mu + \epsilon[(i)] for i = 2, ..., n}

The null hypothesis is tested against the alternative,
H\eqn{_{\mathrm{A}}: \Delta < 0}.

The p-value is computed with the function \code{\link{pgrubbs}}.
}
\examples{
data(Pentosan)
dat <- subset(Pentosan, subset = (material == "A"))
labMeans <- tapply(dat$value, dat$lab, mean)
grubbsTest(x = labMeans, alternative = "two.sided")
}
\references{
Grubbs, F. E. (1950) Sample criteria for testing outlying observations.
\emph{Ann. Math. Stat.} \bold{21}, 27--58.

Wilrich, P.-T. (2011) Critical values of Mandel's h and k,
Grubbs and the Cochran test statistic. \emph{Adv. Stat. Anal.}.
\doi{10.1007/s10182-011-0185-y}.
}
\concept{outliers}
\keyword{htest}
\keyword{univariate}
