% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPMTest.R
\name{NPMTest}
\alias{NPMTest}
\alias{NPMTest.default}
\alias{NPMTest.formula}
\title{All-Pairs Comparisons for Simply Ordered Mean Ranksums}
\usage{
NPMTest(x, ...)

\method{NPMTest}{default}(x, g, ...)

\method{NPMTest}{formula}(formula, data, subset, na.action, ...)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a 
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"PMCMR"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{lower-triangle matrix of the estimated
quantiles of the pairwise test statistics.}
 \item{p.value}{lower-triangle matrix of the p-values for the pairwise tests.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{p.adjust.method}{a character string describing the method for p-value
adjustment.}
\item{model}{a data frame of the input data.}
\item{dist}{a string that denotes the test distribution.}
}
}
\description{
Performs Nashimoto and Wright's all-pairs comparison procedure
for simply ordered mean ranksums.
Their test denoted as NPM test is basically an
extension of Nemenyi's procedure for testing
increasingly ordered alternatives.

The modified procedure uses the property of a simple order,
\eqn{\theta_m' - \theta_m \le \theta_j - \theta_i \le \theta_l' - \theta_l
\qquad (l \le i \le m~\mathrm{and}~ m' \le j \le l')}.
The null hypothesis H\eqn{_{ij}: \theta_i = \theta_j} is tested against
the alternative A\eqn{_{ij}: \theta_i < \theta_j} for any
\eqn{1 \le i < j \le k}.

The p-values are estimated from the studentized range distribution.
If the medians are already increasingly ordered, than the NPM-test simplifies
to the ordinary Nemenyi test (see \code{\link{kwAllPairsNemenyiTest}}).
}
\examples{
## Example from Sachs (1997, p. 402)
x <- c(106, 114, 116, 127, 145,
       110, 125, 143, 148, 151,
       136, 139, 149, 160, 174)
g <- gl(3,5)
levels(g) <- c("A", "B", "C")
NPMTest(x, g)

}
\references{
Nashimoto, K., Wright, F.T., (2005), Multiple comparison procedures
for detecting differences in simply ordered means.
\emph{Comput. Statist. Data Anal.} 48, 291--306.
}
\seealso{
\code{\link{kwAllPairsNemenyiTest}}
}
\concept{
AllPairsComparisons

OrderedAlternatives
}
\keyword{htest}
\keyword{nonparametric}
