% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pfs_score.R
\name{get_pfs_score}
\alias{get_pfs_score}
\title{Calculates the pathway-based mutation accumulate perturbation score}
\usage{
get_pfs_score(
  mut_status,
  percent,
  gene_Ucox_res,
  gene_symbol_Entrez,
  data.dir = NULL,
  organism = "hsa",
  verbose = TRUE,
  Entrez_ID = TRUE,
  gene_set = NULL
)
}
\arguments{
\item{mut_status}{Mutation status of a particular gene in a particular sample. The file can be generated by the function `get_mut_status`.}

\item{percent}{This parameter is used to control the mutation rate of gene. Genes less than this value will be deleted}

\item{gene_Ucox_res}{Results of gene univariate Cox regression.}

\item{gene_symbol_Entrez}{A data table containing gene symbol and gene Entrez ID.}

\item{data.dir}{Location of the "organism"SPIA.RData file containing the pathways data.If set to NULL will look for this file in the extdata folder of the PFS library.}

\item{organism}{A three letter character designating the organism. See a full list at ftp://ftp.genome.jp/pub/kegg/xml/organisms.}

\item{verbose}{If set to TRUE, displays the number of pathways already analyzed.}

\item{Entrez_ID}{Logical,tell whether there are Entrez IDs corresponding to gene symbol in the gene_symbol_Entrez.}

\item{gene_set}{A group of cancer specific gene symbols obtained from the training set}
}
\value{
A binary mutations matrix, which column names is sample and the row name is the pathway.
}
\description{
The function `get_pfs_score` uses to calculate the pathway-based mutation accumulate perturbation score using the matrix of gene mutation state and pathway information.
}
\examples{
#get the path of the mutation annotation file.
data(mut_status,gene_Ucox_res,gene_symbol_Entrez)
#perform the function `get_pfs_score`.
\donttest{pfs_score<-get_pfs_score(mut_status[,1:2],percent=0.03,gene_Ucox_res,gene_symbol_Entrez)}
}
