% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plate.R
\name{add_samples_db}
\alias{add_samples_db}
\title{Add samples from the sample log to the plate}
\usage{
add_samples_db(plate, logIds, dil = 1, namestyle = 1, group = NA)
}
\arguments{
\item{plate}{PlateObj}

\item{logIds}{A vector of log IDs from the sample log.}

\item{dil}{A vector with length corresponding number of logIds. See details.}

\item{namestyle}{A numeric value indicating the naming style. 1 for long names, 2 for short names.}

\item{group}{A string for bioanalytical group.}
}
\value{
PlateObj
}
\description{
Add samples from the sample log to the plate
}
\details{
This function will retrieve sample information from the sample log database using the provided log IDs.
It constructs sample names based on the specified naming style and adds them to the plate.
The `dil` parameter allows specifying dilution factors for each sample, which will be appended to the sample names.
If a single dilution factor is provided, it will be applied to all samples.
}
