## -----------------------------------------------------------------------------
library("PKPDmisc")
library("dplyr")
pkdat <- sd_oral_richpk
head(pkdat)

## -----------------------------------------------------------------------------
pkdat %>% group_by(ID) %>% 
  s_pauc(Time, Conc, list(c(0, 8), c(0, 24), c(8, 24))) %>%
  head

## -----------------------------------------------------------------------------
paucs <- pkdat %>% group_by(ID) %>% 
  s_pauc_("Time", "Conc", list(c(0, 8), c(0, 24), c(8, 24)), digits =1)
head(paucs)

## -----------------------------------------------------------------------------
paucs %>% ungroup() %>% s_quantiles(pAUC0_24, probs = c(0, 0.25, 0.5, 0.75, 1))
paucs %>% ungroup() %>% s_quantiles_("pAUC0_24", probs = c(0, 0.25, 0.5, 0.75, 1))

## -----------------------------------------------------------------------------
sessioninfo::session_info()

