% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk.calc.simple.R
\name{pk.calc.cl}
\alias{pk.calc.cl}
\title{Calculate the (observed oral) clearance}
\usage{
pk.calc.cl(dose, aucinf, unitconv = NA)
}
\arguments{
\item{dose}{the dose administered}

\item{aucinf}{the area under the curve from 0 to infinity or 0 to
tau (the next dose on a regular schedule at steady-state)}

\item{unitconv}{the multiplied factor to use for unit conversion
(e.g. 1000 for mg \code{dose}, time*ng/mL for \code{auc}, and
output in L/time)}
}
\value{
the numeric value of the total (CL) or observed oral
  clearance (CL/F)
}
\description{
Calculate the (observed oral) clearance
}
\references{
Gabrielsson J, Weiner D.
  "Section 2.5.1 Derivation of clearance."  Pharmacokinetic &
  Pharmacodynamic Data Analysis: Concepts and Applications, 4th
  Edition.  Stockholm, Sweden: Swedish Pharmaceutical Press, 2000.
  86-7.
}

