% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk.calc.simple.R
\name{pk.calc.aucabove}
\alias{pk.calc.aucabove}
\title{Calculate the AUC above a given concentration}
\usage{
pk.calc.aucabove(conc, time, conc_above = NA_real_, ..., options = list())
}
\arguments{
\item{conc}{Concentration measured}

\item{time}{Time of concentration measurement (must be monotonically
increasing and the same length as the concentration data)}

\item{conc_above}{The concentration to be above}

\item{...}{Extra arguments.  Currently, the only extra argument that is used
is \code{method} as described in the details section.}

\item{options}{List of changes to the default \code{\link{PKNCA.options}} for
calculations.}
}
\value{
The AUC of the concentration above the limit
}
\description{
Concentrations below the given concentration (\code{conc_above}) will be set
to zero.
}
