% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_sumefftemp.R
\name{calc_sumefftemp}
\alias{calc_sumefftemp}
\title{Calculate sum of effective temperatures (SET)}
\usage{
calc_sumefftemp(x, cf_temp, cf_start, cf_end, cf_limit, set, a, b)
}
\arguments{
\item{x}{SpatRaster list (tmean, tmax, tmin) - numeric - with time attribute}

\item{cf_temp}{\itemize{
\item character - "tmean" for cold days and "tmin" for frost days
}}

\item{cf_start}{\itemize{
\item Date - start of cold/frost timeseries
}}

\item{cf_end}{\itemize{
\item Date - end of cold/frost timeseries
}}

\item{cf_limit}{\itemize{
\item numeric - threshold under which a day is defined as
cold/frost day
}}

\item{set}{\itemize{
\item function - x is cold/frost days, a and b are parameter i.e.
function (x, a, b) a + b*x
}}

\item{a}{\itemize{
\item numeric - parameter for set function
}}

\item{b}{\itemize{
\item numeric - parameter for set function
}}
}
\value{
SpatRaster with sum of effective temperatures.
}
\description{
Calculate sum of effective temperatures (SET)
}
\seealso{
Other Models: 
\code{\link{calc_degreedays}()},
\code{\link{calc_mortality}()},
\code{\link{calc_phenology}()}
}
\concept{Models}
\keyword{internal}
