% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/34_DECISION_TREE.R
\name{decision.tree}
\alias{decision.tree}
\title{Custom decision tree algorithm}
\usage{
decision.tree(
  db,
  rf,
  target,
  min.pct.obs = 0.05,
  min.avg.rate = 0.01,
  p.value = 0.5,
  max.depth = NA,
  monotonicity
)
}
\arguments{
\item{db}{Data frame of risk factors and target variable supplied for interaction extraction.}

\item{rf}{Character vector of risk factor names on which decision tree is run.}

\item{target}{Name of target variable (default indicator 0/1) within db argument.}

\item{min.pct.obs}{Minimum percentage of observation in each leaf. Default is 0.05 or 30 observations.}

\item{min.avg.rate}{Minimum percentage of defaults in each leaf. Default is 0.01 or 1 default case.}

\item{p.value}{Significance level of test of two proportions for splitting criteria. Default is 0.05.}

\item{max.depth}{Maximum tree depth.}

\item{monotonicity}{Logical indicator. If \code{TRUE}, observed trend between risk factor and target will be preserved
in splitting node.}
}
\value{
The command \code{decision.tree} returns a object of class cdt. For details on output elements see the Examples.
}
\description{
\code{decision.tree} runs customized decision tree algorithm. Customization refers to minimum
percentage of observations and defaults in each node, maximum tree depth, monotonicity condition
at each splitting node and statistical test (test of two proportions) used for node splitting.
}
\examples{
suppressMessages(library(PDtoolkit))
data(loans)
#modify risk factors in order to show how the function works with missing values
loans$"Account Balance"[1:10] <- NA
loans$"Duration of Credit (month)"[c(13, 15)] <- NA
tree.res <- decision.tree(db = loans,
	rf = c("Account Balance", "Duration of Credit (month)"), 
	target = "Creditability",
	min.pct.obs = 0.05,
	min.avg.rate = 0.01,
	p.value = 0.05,
	max.depth = NA,
	monotonicity = TRUE)
str(tree.res)
}
\seealso{
\code{\link{predict.cdt}}
}
