% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mblrr.R
\name{mblrr}
\alias{mblrr}
\title{A function to perform a Local Robust Regression in Ranges defined by Qunantile-filtering}
\usage{
mblrr(x, y, sig.level = 0.01, normalize = FALSE)
}
\arguments{
\item{x}{is the cycle numbers (x-axis).}

\item{y}{is the cycle dependent fluorescence amplitude (y-axis).}

\item{sig.level}{is the significance level for the correlation test.}

\item{normalize}{is a logical parameter, which indicates if the amplification curve
data should be normalized to the 99 percent quantile of the amplification curve.}
}
\value{
gives a \code{numeric} (S3 class, type of \code{double}) as output 
for the regressed regions
}
\description{
\code{mblrr} is a function to perform the Median based Local Robust Regression (mblrr)
from a quantitative PCR experiment. In detail, this function attempts to break the
amplification curve in two parts (head (~background) and tail (~plateau)).
Subsequent, a robust linear regression analysis (\code{\link{lmrob}}) is
preformed individually on both parts. The rational behind this analysis is
that the slope and intercept of an amplification curve differ in the
background and plateau region.
}
\details{
\emph{mblrr_intercept_bg} is the intercept of the head region,
\emph{mblrr_slope_bg} is the slope of the head region,
\emph{mblrr_cor_bg} is the coefficient of correlation of the head region,
\emph{mblrr_intercept_pt} is the intercept of the tail region,
\emph{mblrr_intercept_pt} is the slope of the tail region,
\emph{mblrr_cor_pt} is the coefficient of correlation of the tail region
}
\examples{

# Perform an mblrr analysis on noise (negative) amplification data of qPCR data
# with 35 cycles.
library(qpcR)
mblrr(x=boggy[, 1], y=boggy[, 2], normalize=TRUE)

}
\author{
Stefan Roediger, Michal Burdukiewcz
}
\keyword{regression}
\keyword{segmented}
