% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stocksCRSPxts.R
\name{stocksCRSPxts}
\alias{stocksCRSPxts}
\title{Select CRSP Stocks Returns}
\usage{
stocksCRSPxts(
  data,
  dateRange = c("1993-01-31", "2015-12-31"),
  tickerSet = NULL
)
}
\arguments{
\item{data}{One of the data.table objects stocksCRSP, stocksCRSPweekly,
stocksCRSPdaily}

\item{dateRange}{Character vector with two components a start date
and an end date using format "yyyy-mm-dd".  Default is the entire
stocksCRSP data dates range c("1993-01-31","2015-12-32")}

\item{tickerSet}{A subset of tickers of the stocks in stocksCRSP. The
default is tickerSet = NULL, which results in selection of all stocks
in stocksCRSP.}
}
\value{
A multivariate xts object of stock returns
}
\description{
A function to extract a subset of the stocksCRSP data.table
specified by a date range and a set of tickers, with convenient defaults,
and convert it to an xts object
}
\examples{
library(PCRA)
library(xts)
library(data.table)
class(stocksCRSP)
args(stocksCRSPxts)
tickers4 <- c("DHR","CSL","AVP","AMWD")
dateRange <- c("2011-01-31","2015-12-31")
returns4 <- stocksCRSPxts(stocksCRSP, dateRange = dateRange,
                           tickerSet = tickers4) 
class(returns4)
dim(returns4)
names(returns4)
range(index(returns4))                         
}
