% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCMTree.R
\name{PCMTreeDropClade}
\alias{PCMTreeDropClade}
\title{Drop a clade from a phylogenetic tree}
\usage{
PCMTreeDropClade(tree, cladeRootNode, tableAncestors = NULL, X = NULL,
  returnPhylo = is.null(X), errorOnMissing = FALSE)
}
\arguments{
\item{tree}{a phylo object}

\item{cladeRootNode}{a character string denoting the label or an integer denoting a node in the tree}

\item{tableAncestors}{an integer matrix returned by a previous call to PCMTreeTableAncestors(tree) or NULL.}

\item{X}{an optional k x N matrix with trait value vectors for each tip in tree.}

\item{returnPhylo}{logical indicating if only the phylo object associated with the tree after dropping the clade should be returned. Defaults to \code{is.null(X)}}

\item{errorOnMissing}{logical indicating if an error should be rased if cladeRootNode is not among the
nodes in tree. Default FALSE, meaning that if cladeRootNode is not a node in tree the tree (and X if
returnPhylo is FALSE) is/are returned unchanged.}
}
\value{
If returnPhylo is TRUE, a phylo object associated with the remaining tree after dropping the clade, otherise, a list with two named members :
\itemize{
\item{tree}{the phylo object associated with the remaining tree after dropping the clade}
\item{X}{the submatrix of X with columns corresponding to the tips in the remaining tree}
}
}
\description{
Drop a clade from a phylogenetic tree
}
\seealso{
PCMTreeSpliAtNode PCMTreeDropClade
}
