% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCM.R
\name{PCMTableParameterizations}
\alias{PCMTableParameterizations}
\title{Cartesian product of possible parameterizations for the different parameters of a model}
\usage{
PCMTableParameterizations(model,
  listParameterizations = PCMListParameterizations(model, ...), ...)
}
\arguments{
\item{model}{a PCM object.}

\item{listParameterizations}{a list returned by a method for `PCMListParameterizations`.
Default: `PCMListParameterizations(model, ...)`.}

\item{...}{additional arguments passed to `PCMListParameterizations(model, ...)`.}
}
\value{
a data.table object.
}
\description{
This function generates a data.table in which each column corresponds to
one parameter of model and each row corresponds to one combination of parameterizations
for the model parameters, such that the whole table corresponds to the Cartesian product
of the lists found in `listParameterizations`. Usually, subsets of this table
should be passed to `PCMGenerateParameterizations`
}
