% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot3D.R
\name{plot3D}
\alias{plot3D}
\alias{plot3D.default}
\alias{plot3D.PAsso}
\title{3-D P-P plot and false color level plot for the inspection of the partial association analysis}
\usage{
plot3D(object, y1, y2, ...)

\method{plot3D}{default}(object, y1, y2, ...)

\method{plot3D}{PAsso}(object, y1, y2, type = c("surface3D", "contour"), ...)
}
\arguments{
\item{object}{A PAsso class of object.}

\item{y1}{A string to specify the first response for the 3D plot.}

\item{y2}{A string to specify the second response for the 3D plot. If either one of the
y1 or y2 is missing. The \code{plot3D} will draw 3D plots for all pairs of responses.}

\item{...}{Additional optional arguments.}

\item{type}{A character string specifying the trace type (e.g. "surface3D", "contour"). "contour" creates a
2D contour plot between u and v.}
}
\value{
If response y1 or y2 is not specified, a list of \code{"plotly"} objects includes
all pairs of responses will be returned (with name "response 1 v.s. response 2" etc.). If
responses y1 and y2 are specified, returns a 3D plot as \code{"plotly"} object.
}
\description{
A list of 3-D P-P plots (or false color level plots when \code{type = "contour"})
for the inspection of the partial association analysis. Each plot is either 3-D P-P plot or level plot
from an empirical copula trained from the surrogate residuals of a pair of responses.
}
\details{
All the plots are based on surrogate residuals generated from \code{"residuals"}
function in \code{sure}. Graphics are designed based on
PAsso and \code{"plotly"}.
}
\examples{
# Did not run this to save time
# data("ANES2016")
# PAsso_3v <- PAsso(responses = c("PreVote.num", "PID", "selfLR"),
#                   adjustments = c("income.num", "age", "edu.year"),
#                   data = ANES2016)

# plot3D(PAsso_3v, y1="PID", y2="selfLR")
# plot3D(PAsso_3v, y1="PID", y2="selfLR", type = "contour")
}
