% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sedentary_summary.R
\name{Sedentary}
\alias{Sedentary}
\title{Sedentary Physical Activity Summary}
\usage{
Sedentary(final_dat, bed_time, takeoff_time)
}
\arguments{
\item{final_dat}{Raw event file, will be cleaned in this function. Event file is required for this function.}

\item{bed_time}{Sleep and wake up time log, reported by participants. Log is not required for this function.}

\item{takeoff_time}{Take on and off time log, reported by participants. Log is not required for this function.}
}
\value{
\code{Year} The calendar year of recorded event

\code{Month} The calendar month of recorded event

\code{Day}   The calendar day of recorded event

\code{Dayofweek} The day of that week

\code{Weekday_or_weekend}  The recored event date is a weekday or weekend (0 for weekday, 1 for weekend)

\code{break_per_day} Number of interrupting sedentary behavior during the given period of time

\code{break_rate} Rate of interrupting sedentary behavior

\code{mean_sed_bout_length} Mean sedentary bout length. It is the average of the duration time for all sedentary activities

\code{prop_of_sed_time_greater_20min} Proportions of sedentary bout greater than 20 minutes

\code{prop_of_sed_time_greater_60min} Proportions of sedentary bout greater than 60 minutes

\code{prop_of_sed_time_greater_120min} Proportions of sedentary bout greater than 120 minutes

\code{total_sed_time_greater_20min} Total sedentary time greater than 20 minutes

\code{total_sed_time_greater_60min} Total sedentary time greater than 60 minutes

\code{total_sed_time_greater_120min} Total sedentary time greater than 120 minutes

\code{percentile_sed_time_5}  5\% Percentile of sedentary time

\code{percentile_sed_time_25} 25\% Percentile of sedentary time

\code{percentile_sed_time_50} 50\% Percentile of sedentary time

\code{percentile_sed_time_75} 75\% Percentile of sedentary time

\code{percentile_sed_time_95} 95\% Percentile of sedentary time

\code{alpha_sed} alpha of sedentary time, see details

\code{prop_sed_time_6_12} Proportions of sedentary time between 6:00-12:00

\code{prop_sed_time_12_18} Proportions of sedentary time between 12:00-18:00

\code{prop_sed_time_18_22} Proportions of sedentary time between 18:00-22:00

\code{sed_time_in_30_and_60} Minutes Spent in Sitting/Lying Bouts (at least 30 and less 60 minutes in duration)

\code{sed_num_in_30_and_60} Number of in Sitting/Lying Bouts (at least 30 and less 60 minutes in duration)
}
\description{
Summarize sedentary features using proportions and percentiles
}
\details{
Proportions of sedentary bout greater than 20/60/120 minutes is the ratio of the number of sedentary bouts greater than 20/60/120 minutes to the total number of sedentary recordings.

Total sedentary time greater than 20/60/120 minutes is the summation of the sedentary durations which are greater than 20/60/120 minutes.

To calculate 5\%/25\%/75\%/95\% percentile of sedentary time, all of the recorded sedentary durations are listed and R function \emph{quantile} is used to find the percentiles.

alpha_sed is defined by \code{1+1/M}, where \code{M} is the average of \code{log(sedentary bout length /minimum sedentary bout length)}.

Proportions of sedentary time between 6:00-12:00/12:00-18:00/18:00-22:00 is the ratio of the sedentary durations to the total activity durations between 6:00-12:00/12:00-18:00/18:00-22:00.
}
\examples{
#For CRAN less than 5s running time policy, we only select the first day to run.
r2=Sedentary(sample_event[1:3095,],sample_bed_time[1,],sample_takeon_log[1,])
summary(r2)
}

