% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PAMpalSettings.R
\name{PAMpalSettings}
\alias{PAMpalSettings}
\title{Constructor for PAMpalSettings Object}
\usage{
PAMpalSettings(
  db = NULL,
  binaries = NULL,
  settings = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{db}{the full path to a Pamguard database file}

\item{binaries}{a folder containing Pamguard binary files, all subfolders will
also be added}

\item{settings}{an XML settings file from Pamguard}

\item{verbose}{logical flag to show messages}

\item{\dots}{values to pass on to default \link{standardClickCalcs} function}
}
\value{
A PAMpalSettings object
}
\description{
Create a PAMpalSettings object. Any values that are not supplied
  will be asked for interactively. Three processing functions will also be added
  by default: \link{standardClickCalcs}, \link{roccaWhistleCalcs}, and
  \link{standardCepstrumCalcs}
}
\examples{

# can be run with no arguments with popup menu selections
if(interactive()) pps <- PAMpalSettings()
db <- system.file('extdata', 'Example.sqlite3', package='PAMpal')
bin <- system.file('extdata', 'Binaries', package='PAMpal')
# or data folders can be supplied ahead of time
if(interactive()) pps <- PAMpalSettings(db=db, binaries=bin)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
