% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BARDM.Cov.R
\name{BARDM.Cov}
\alias{BARDM.Cov}
\title{This function implements Bayesian inference of BARD-Mallows model with covariates.}
\usage{
BARDM.Cov(datfile, Covdatfile, nRe, iter)
}
\arguments{
\item{datfile}{A matrix or dataframe. This is the data where our algorithm will work on. Each colomn denotes a ranker's ranking. The data should be in entity-based format.}

\item{Covdatfile}{A matrix or dataframe. Each column denotes a covariate.}

\item{nRe}{A number. Number of relevant entities}

\item{iter}{A number. Numner of iterations of MCMC. Defaulted as 1000.}
}
\value{
List. It contains Bayesian posterior samples of all the parameters and log-likelihood.
\enumerate{
  \item I.mat: posterior samples of I
  \item phi.mat: posterior samples of phi
  \item smlgamma.mat: posterior samples of gamma
  \item l.mat: posterior samples of log-likelihood.
  \item theta.mat: posterior samples of coefficients of covariates.
}
}
\description{
This function implements Bayesian inference of BARD-Mallows model with covariates.
}
\details{
The covariates are incoporated in the BARDM framework as indicators of groupmember. That is covariates are associated to group members via a logistic regression.
}
\examples{
a=NBANFL()
BARDM.Cov(t(a$NFLdata),a$NFLcov,nRe=10,iter=10)
\donttest{BARDM.Cov(t(a$NFLdata),a$NFLcov,nRe=10,iter=1000)}
}
