% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate.p.values.R
\name{calculate.p.values}
\alias{calculate.p.values}
\title{Calculate p-values}
\usage{
calculate.p.values(
  x,
  x.distribution,
  x.zrange.mean,
  x.zrange.median,
  x.zrange.trimmean,
  x.fraction.kmeans,
  x.cosine.similarity,
  null.zrange.mean,
  null.zrange.median,
  null.zrange.trimmean,
  null.fraction.kmeans,
  null.cosine.similarity,
  kmeans.nstart = 1
)
}
\arguments{
\item{x}{A numeric vector of values for an observed transcript.}

\item{x.distribution}{A numeric code corresponding to the optimal distribution of \code{x} as returned by \code{identify.bic.optimal.data.distribution()}.}

\item{x.zrange.mean}{A number, the range of the z-scores calculated using the mean and standard deviation of \code{x}.}

\item{x.zrange.median}{A number, the range of the z-scores calculated using the median and median absolute deviation of \code{x}.}

\item{x.zrange.trimmean}{A number, the range of the z-scores calculated using the trimmed mean and trimmed standard deviation of \code{x}.}

\item{x.fraction.kmeans}{A number, the k-means fraction of \code{x}.}

\item{x.cosine.similarity}{A number, the cosine similarity of \code{x}.}

\item{null.zrange.mean}{A numeric vector, the ranges of the z-scores calculated using the mean and standard deviation of each transcript in the null data.}

\item{null.zrange.median}{A numeric vector, the ranges of the z-scores calculated using the median and median absolute deviation of each transcript in the null data.}

\item{null.zrange.trimmean}{A numeric vector, the ranges of the z-scores calculated using the trimmed mean and trimmed standard deviation of each transcript in the null data.}

\item{null.fraction.kmeans}{A numeric vector, the k-means fraction of each transcript in the null data.}

\item{null.cosine.similarity}{A numeric vector, the cosine similarity of each transcript in the null data.}

\item{kmeans.nstart}{The number of random starts when computing k-means fraction; default is 1.  See \code{?stats::kmeans} for further details.}
}
\value{
A list consisting of the following entries:
\itemize{
\item \code{p.values}: a vector of p-values for the outlier test run on each sample (up until the p-value exceeds \code{p.value.threshold}); and
\item \code{outlier.statistics.list}, a list of vectors containing the values of the outlier statistics calculated from the remaining samples.  The list will be of length equal to one plus the total number of outliers (i.e., the number of samples with an outlier test p-value less than \code{p.value.threshold}) and will contain entries \code{outlier.statistics.N}, where \code{N} is between zero and the total number of outliers.  \code{outlier.statistics.N} is the vector of outlier statistics after excluding the \code{N}th outlier sample, with \code{outlier.statistics.0} being for the complete transcript.
}
}
\description{
Calculate p-values for each sample of a single transcript.
}
\examples{
data(example.data.for.calculate.p.values);
i <- 1; # row index of transcript to test
calculate.p.values(
   x = example.data.for.calculate.p.values$data[i,],
   x.distribution = example.data.for.calculate.p.values$x.distribution[i],
   x.zrange.mean = example.data.for.calculate.p.values$x.zrange.mean[i],
   x.zrange.median = example.data.for.calculate.p.values$x.zrange.median[i],
   x.zrange.trimmean = example.data.for.calculate.p.values$x.zrange.trimmean[i],
   x.fraction.kmeans = example.data.for.calculate.p.values$x.fraction.kmeans[i],
   x.cosine.similarity = example.data.for.calculate.p.values$x.cosine.similarity[i],
   null.zrange.mean = example.data.for.calculate.p.values$null.zrange.mean,
   null.zrange.median = example.data.for.calculate.p.values$null.zrange.median,
   null.zrange.trimmean = example.data.for.calculate.p.values$null.zrange.trimmean,
   null.fraction.kmeans = example.data.for.calculate.p.values$null.fraction.kmeans,
   null.cosine.similarity = example.data.for.calculate.p.values$null.cosine.similarity,
   kmeans.nstart = example.data.for.calculate.p.values$kmeans.nstart
   );
}
