% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stextGrob.R
\name{stextGrob}
\alias{stextGrob}
\alias{grid.stext}
\title{Draw Shadow Text}
\usage{
stextGrob(
  label,
  x = grid::unit(0.5, "npc"),
  y = grid::unit(0.5, "npc"),
  col = "white",
  fill = "black",
  r = 0.1,
  gp = grid::gpar(),
  vp = NULL,
  name = NULL,
  ...
)
}
\arguments{
\item{label}{A \code{character} or \code{\link{expression}} vector, see 
\code{\link{textGrob}}.}

\item{x, y}{Horizontal and vertical text position as \code{\link[grid]{unit}} 
objects passed to \code{\link{grid.text}}.}

\item{col, fill}{Framing and fill color passed to \code{\link[grid]{gpar}}.}

\item{r}{Blur radius of colored framing as \code{numeric}.}

\item{name, gp, vp}{Graphical parameters passed to \code{\link{gTree}}.}

\item{...}{Additional arguments passed to \code{\link[grid]{grid.text}}.}
}
\value{
A text grob created by \code{\link{gTree}}.
}
\description{
Create and draw shadow text by wrapping a textual expression into a colored 
framing.
}
\examples{
library(grid)
grid.newpage()
grid.rect(gp = gpar(fill = "grey"))
grid.stext("test")

}
\seealso{
\code{\link[grid]{grid.text}}.
}
\author{
Baptiste Auguie, Florian Detsch
}
\concept{grob userlevel}
