% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_obwoe.R
\name{obwoe_bin_cutoff}
\alias{obwoe_bin_cutoff}
\title{Bin Cutoff Parameter}
\usage{
obwoe_bin_cutoff(range = c(0.01, 0.1), trans = NULL)
}
\arguments{
\item{range}{A two-element numeric vector specifying the minimum and maximum
values for the parameter. Default is \code{c(0.01, 0.10)}.}

\item{trans}{A transformation object from the \code{scales} package, or
\code{NULL} for no transformation. Default is \code{NULL}.}
}
\value{
A \code{dials} quantitative parameter object.
}
\description{
A quantitative tuning parameter for the minimum bin support (proportion
of observations per bin) in \code{\link{step_obwoe}}.
}
\details{
The bin cutoff specifies the minimum proportion of observations that each
bin must contain. Bins with fewer observations are merged with adjacent
bins. This serves as a regularization mechanism:

\itemize{
  \item Lower values (e.g., 0.01) allow smaller bins, capturing subtle
    patterns but risking unstable WoE estimates.
  \item Higher values (e.g., 0.10) enforce larger bins, producing more
    stable estimates but potentially missing important patterns.
}

For credit scoring, values between 0.02 and 0.05 are typical. Regulatory
guidelines often require minimum bin sizes for model stability.
}
\examples{
obwoe_bin_cutoff()
obwoe_bin_cutoff(range = c(0.02, 0.08))

}
\seealso{
\code{\link{step_obwoe}}, \code{\link{control.obwoe}}
}
