% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MxCycleDetection.R
\name{imxAddDependency}
\alias{imxAddDependency}
\title{Add a dependency}
\usage{
imxAddDependency(source, sink, dependencies)
}
\arguments{
\item{source}{a character vector of the names of the computation sources (inputs)}

\item{sink}{the name of the computation sink (output)}

\item{dependencies}{the dependency graph}
}
\description{
The dependency tracking system ensures that algebra and
fitfunctions are not recomputed if their inputs have not changed.
Dependency information is computed prior to handing the model off
to the optimizer to reduce overhead during optimization.
}
\details{
Each free parameter keeps track of all the objects that store that
free parameter and the transitive closure of all algebras and fit
functions that depend on that free parameter.  Similarly, each
definition variable keeps track of all the objects that store that
free parameter and the transitive closure of all the algebras and
fit functions that depend on that free parameter. At each
iteration of the optimization, when the free parameter values are
updated, all of the dependencies of that free parameter are marked
as dirty (see \code{omxFitFunction.repopulateFun}). After an
algebra or fit function is computed, \code{omxMarkClean()} is
called to to indicate that the algebra or fit function is updated.
Similarly, when definition variables are populated in FIML, all of
the dependencies of the definition variables are marked as dirty.
Particularly for FIML, the fact that non-definition-variable
dependencies remain clean is a big performance gain.
}

